<form action="<?php echo e(route('cart.add')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="d-flex align-items-center justify-content-between mb-4">
        <h5 class="modal-title flex-grow-1 text-center" id="buyNowModalLabel">
            <?php echo e(translate('Shipping_Method')); ?>

        </h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <div class="d-flex gap-2 mb-3">
        <img src="<?php echo e(theme_asset(path: 'public/assets/front-end/img/icons/car.svg')); ?>" alt="">
        <div><?php echo e(translate('Choose_Shipping_Method')); ?></div>
    </div>

    <div class="form-group">
        <div class="border rounded p-3 d-flex flex-column gap-2">
            <?php $__currentLoopData = $shipping_method_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shippingMethodKey => $shippingMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="d-flex gap-2 align-items-center">
                <input type="radio" class="show" name="shipping_method_id" id="shipping_method_id-<?php echo e($shippingMethod['id']); ?>" value="<?php echo e($shippingMethod['id']); ?>" <?php echo e($shippingMethodKey == 0 ? 'checked':''); ?>>
                <label class="mb-0" for="shipping_method_id-<?php echo e($shippingMethod['id']); ?>">
                    <?php echo e(ucfirst($shippingMethod['title'])); ?> (<?php echo e($shippingMethod['duration']); ?>) <?php echo e(webCurrencyConverter($shippingMethod['cost'])); ?>

                </label>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <input type="hidden" class="form-control" value="1" name="shipping_method_exist">

        </div>
    </div>

    <div class="row d-none">
        <?php $__currentLoopData = $productData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inputKey => $productInputData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-6">
                <label>
                    <?php echo e($inputKey); ?>

                </label>
                <input type="text" class="form-control" value="<?php echo e($productInputData); ?>" name="<?php echo e($inputKey); ?>">
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="d-flex justify-content-center mt-4">
        <button type="submit" class="btn text-white web--bg-primary">
            <?php echo e(translate('Proceed_to_Checkout')); ?>

        </button>
    </div>
</form>
<?php /**PATH /home/tupatane/public_html/resources/themes/default/layouts/front-end/partials/modal/_buy-now-data.blade.php ENDPATH**/ ?>