<?php $__env->startSection('title', translate('product_Preview')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid text-start">
        <div class="d-flex align-items-center justify-content-between flex-wrap gap-10 mb-3">
            <div class="">
                <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                    <img src="<?php echo e(asset('public/assets/back-end/img/inhouse-product-list.png')); ?>" alt="">
                    <?php echo e(translate('product_details')); ?>

                </h2>
            </div>
        </div>

        <div class="card card-top-bg-element">
            <div class="card-body">
                <div>
                    <div class="media flex-nowrap flex-column flex-sm-row gap-3 flex-grow-1 align-items-center align-items-md-start">
                        <div class="d-flex flex-column align-items-center __min-w-165px">
                            <a class="aspect-1 float-left overflow-hidden"
                               href="<?php echo e(getStorageImages(path:$product->thumbnail_full_url,type: 'backend-product')); ?>"
                               data-lightbox="product-gallery-<?php echo e($product['id']); ?>">
                                <img class="avatar avatar-170 rounded-0 img-fit"
                                     src="<?php echo e(getStorageImages(path:$product->thumbnail_full_url,type: 'backend-product')); ?>"
                                     alt="">
                            </a>
                            <?php if($productActive && $isActive): ?>
                                <a href="<?php echo e(route('product', $product['slug'])); ?>"
                                   class="btn btn-outline--primary mr-1 mt-2" target="_blank">
                                    <i class="tio-globe"></i>
                                    <?php echo e(translate('view_live')); ?>

                                </a>
                            <?php endif; ?>

                            <?php if($product->digital_file_ready_full_url['path']): ?>
                                <span data-file-path="<?php echo e($product->digital_file_ready_full_url['path']); ?>"
                                      class="btn btn-outline--primary mr-1 mt-2 text-nowrap d-flex align-items-center justify-content-center gap-1 getDownloadFileUsingFileUrl" data-toggle="tooltip" data-placement="top" data-title="<?php echo e(translate('Download')); ?>">
                                    <i class="tio-download"></i>
                                    <span class="d-block d-md-none">
                                    <?php echo e(translate('download')); ?>

                                    </span>
                                </span>
                            <?php endif; ?>
                        </div>

                        <div class="d-block flex-grow-1 w-max-md-100">
                            <div class="d-flex flex-wrap justify-content-between align-items-center">
                                <?php ($languages = getWebConfig(name:'pnc_language')); ?>
                                <?php ($defaultLanguage = 'en'); ?>
                                <?php ($defaultLanguage = $languages[0]); ?>
                                <ul class="nav nav-tabs w-fit-content mb-2">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="nav-item text-capitalize">
                                            <a class="nav-link lang-link <?php echo e($language == $defaultLanguage? 'active':''); ?>"
                                            href="javascript:"
                                            id="<?php echo e($language); ?>-link"><?php echo e(getLanguageName($language).'('.strtoupper($language).')'); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                                <div class="pb-4">
                                    <a href="<?php echo e(route('vendor.products.update', [$product['id']])); ?>" class="btn btn-sm btn--primary"><?php echo e(translate('Edit')); ?> <i class="tio-edit"></i> </a>
                                </div>
                            </div>
                            <div class="d-flex flex-wrap align-items-center flex-sm-nowrap justify-content-between gap-3 min-h-50">
                                <div class="d-flex flex-wrap gap-2 align-items-center">
                                    <?php if($product->product_type == 'physical' && !empty($product->color_image) && count(json_decode($product->color_image))>0): ?>
                                        <?php $__currentLoopData = $product->color_images_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colorImageKey => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="<?php echo e($colorImageKey > 4 ? 'd-none' : ''); ?>">
                                                <a class="aspect-1 float-left overflow-hidden d-block border rounded-lg position-relative"
                                                   href="<?php echo e(getStorageImages(path: $photo['image_name'], type: 'backend-product')); ?>"
                                                   data-lightbox="product-gallery-<?php echo e($product['id']); ?>">
                                                    <img width="50"  class="img-fit max-50" alt=""
                                                         src="<?php echo e(getStorageImages(path: $photo['image_name'], type: 'backend-product')); ?>">
                                                    <?php if($colorImageKey > 3): ?>
                                                        <div class="extra-images">
                                                            <span class="extra-image-count">
                                                                +<?php echo e((count($product->color_images_full_url) - $colorImageKey)); ?>

                                                            </span>
                                                        </div>
                                                    <?php endif; ?>
                                                </a>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <?php $__currentLoopData = $product->images_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageKey => $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="<?php echo e($imageKey > 4 ? 'd-none' : ''); ?>">
                                                <a class="aspect-1 float-left overflow-hidden d-block border rounded-lg position-relative <?php echo e($imageKey > 4 ? 'd-none' : ''); ?>"
                                                   href="<?php echo e(getStorageImages(path: $photo, type: 'backend-product')); ?>"
                                                   data-lightbox="product-gallery-<?php echo e($product['id']); ?>">
                                                    <img width="50"  class="img-fit max-50" alt=""
                                                         src="<?php echo e(getStorageImages(path: $photo, type: 'backend-product')); ?>">
                                                    <?php if($imageKey > 4): ?>
                                                        <div class="extra-images">
                                                            <span class="extra-image-count">
                                                                +<?php echo e((count($product->images_full_url) - $imageKey)); ?>

                                                            </span>
                                                        </div>
                                                    <?php endif; ?>
                                                </a>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>

                                <div class="d-flex flex-column gap-2">
                                    <div class="d-flex gap-3 flex-nowrap justify-content-sm-end align-items-center lh-1 badge badge--primary-light height-30px ">
                                        <span class="text-dark">
                                            <?php echo e(count($product->orderDetails)); ?> <?php echo e(translate('orders')); ?>

                                        </span>
                                            <span class="border-left py-2"></span>
                                            <div class="review-hover position-relative cursor-pointer d-flex gap-2 align-items-center">
                                                <i class="tio-star"></i>
                                                <span>
                                                <?php echo e(count($product->rating)>0 ? number_format($product->rating[0]->average, 2, '.', ' '):0); ?>

                                            </span>
                                                <div class="review-details-popup">
                                                    <h6 class="mb-2"><?php echo e(translate('rating')); ?></h6>
                                                    <div class="">
                                                        <ul class="list-unstyled list-unstyled-py-2 mb-0">
                                                            <?php ($total = $product->reviews->count()); ?>

                                                            <li class="d-flex align-items-center font-size-sm">
                                                                <?php ($five = getRatingCount($product['id'], 5)); ?>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>">
                                                            <?php echo e(translate('5')); ?> <?php echo e(translate('star')); ?>

                                                        </span>
                                                                <div class="progress flex-grow-1">
                                                                    <div class="progress-bar" role="progressbar"
                                                                         style="width: <?php echo e($total == 0 ? 0 : ($five/$total)*100); ?>%;"
                                                                         aria-valuenow="<?php echo e($total == 0 ? 0 : ($five/$total)*100); ?>"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($five); ?></span>
                                                            </li>

                                                            <li class="d-flex align-items-center font-size-sm">
                                                                <?php ($four=getRatingCount($product['id'],4)); ?>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(translate('4')); ?> <?php echo e(translate('star')); ?></span>
                                                                <div class="progress flex-grow-1">
                                                                    <div class="progress-bar" role="progressbar"
                                                                         style="width: <?php echo e($total == 0 ? 0 : ($four/$total)*100); ?>%;"
                                                                         aria-valuenow="<?php echo e($total == 0 ? 0 : ($four/$total)*100); ?>"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($four); ?></span>
                                                            </li>

                                                            <li class="d-flex align-items-center font-size-sm">
                                                                <?php ($three=getRatingCount($product['id'],3)); ?>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(translate('3')); ?> <?php echo e(translate('star')); ?></span>
                                                                <div class="progress flex-grow-1">
                                                                    <div class="progress-bar" role="progressbar"
                                                                         style="width: <?php echo e($total == 0 ? 0 : ($three/$total)*100); ?>%;"
                                                                         aria-valuenow="<?php echo e($total == 0 ? 0 : ($three/$total)*100); ?>"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($three); ?></span>
                                                            </li>

                                                            <li class="d-flex align-items-center font-size-sm">
                                                                <?php ($two=getRatingCount($product['id'],2)); ?>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(translate('2')); ?> <?php echo e(translate('star')); ?></span>
                                                                <div class="progress flex-grow-1">
                                                                    <div class="progress-bar" role="progressbar"
                                                                         style="width: <?php echo e($total == 0 ? 0 : ($two/$total)*100); ?>%;"
                                                                         aria-valuenow="<?php echo e($total == 0 ? 0 : ($two/$total)*100); ?>"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($two); ?></span>
                                                            </li>

                                                            <li class="d-flex align-items-center font-size-sm">
                                                                <?php ($one=getRatingCount($product['id'],1)); ?>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'ml-3' : 'mr-3'); ?>"><?php echo e(translate('1')); ?> <?php echo e(translate('star')); ?></span>
                                                                <div class="progress flex-grow-1">
                                                                    <div class="progress-bar" role="progressbar"
                                                                         style="width: <?php echo e($total == 0 ? 0 : ($one/$total)*100); ?>%;"
                                                                         aria-valuenow="<?php echo e($total == 0 ? 0 : ($one/$total)*100); ?>"
                                                                         aria-valuemin="0" aria-valuemax="100"></div>
                                                                </div>
                                                                <span
                                                                    class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>"><?php echo e($one); ?></span>
                                                            </li>

                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            <span class="border-left py-2"></span>
                                            <span class="text-dark">
                                            <?php echo e($product->reviews->whereNotNull('comment')->count()); ?> <?php echo e(translate('reviews')); ?>

                                        </span>
                                    </div>

                                    <div class="d-flex align-items-center gap-2">
                                        <span><?php echo e(translate('Status')); ?></span>
                                        <?php if($product['request_status'] == 0): ?>
                                            <span class="__badge badge badge--primary-2"><?php echo e(translate('pending')); ?></span>
                                        <?php elseif($product['request_status'] == 1): ?>
                                            <span class="__badge badge badge-soft-success"><?php echo e(translate('approved')); ?></span>
                                        <?php else: ?>
                                            <span class="__badge badge badge-soft-danger"><?php echo e(translate('rejected')); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </div>

                            </div>
                            <div class="d-block mt-2">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        if (count($product['translations'])) {
                                            $translate = [];
                                            foreach ($product['translations'] as $translation) {
                                                if ($translation->locale == $language && $translation->key == "name") {
                                                    $translate[$language]['name'] = $translation->value;
                                                }
                                                if ($translation->locale == $language && $translation->key == "description") {
                                                    $translate[$language]['description'] = $translation->value;
                                                }
                                            }
                                        }
                                        ?>
                                    <div class="<?php echo e($language != 'en'? 'd-none':''); ?> lang-form" id="<?php echo e($language); ?>-form">
                                        <div class="d-flex">
                                            <h2 class="mb-2 pb-1 text-gulf-blue"><?php echo e($translate[$language]['name']??$product['name']); ?></h2>
                                        </div>
                                        <div class="">
                                            <label class="text-gulf-blue font-weight-bold"><?php echo e(translate('description').' : '); ?></label>
                                            <div class="rich-editor-html-content">
                                                <?php echo $translate[$language]['description']??$product['details']; ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <div class="d-flex gap-3 flex-wrap">
                    <div class="border p-3 mobile-w-100 w-170">
                        <div class="d-flex flex-column mb-1">
                            <h6 class="font-weight-normal text-capitalize"><?php echo e(translate('total_sold')); ?> :</h6>
                            <h3 class="text-primary fs-18"><?php echo e($product['qtySum']); ?></h3>
                        </div>
                        <div class="d-flex flex-column">
                            <h6 class="font-weight-normal text-capitalize"><?php echo e(translate('total_sold_amount')); ?> :</h6>
                            <h3 class="text-primary fs-18">
                                <?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: ($product['priceSum'] - $product['discountSum'])))); ?>

                            </h3>
                        </div>
                    </div>

                    <div class="row gy-3 flex-grow-1">
                        <div class="col-sm-6 col-xl-4">
                            <h4 class="mb-3 text-capitalize"><?php echo e(translate('general_information')); ?></h4>
                            <div class="pair-list">
                                <?php if($product?->product_type == 'physical'): ?>
                                <div>
                                    <span class="key text-nowrap"><?php echo e(translate('brand')); ?></span>
                                    <span>:</span>
                                    <span class="value">
                                        <?php echo e(isset($product->brand) ? $product->brand->default_name : translate('brand_not_found')); ?>

                                    </span>
                                </div>
                                <?php endif; ?>

                                <div>
                                    <span class="key text-nowrap"><?php echo e(translate('category')); ?></span>
                                    <span>:</span>
                                    <span class="value">
                                        <?php echo e(isset($product->category) ? $product->category->default_name : translate('category_not_found')); ?>

                                    </span>
                                </div>

                                <div>
                                    <span class="key text-nowrap"><?php echo e(translate('product_type')); ?></span>
                                    <span>:</span>
                                    <span class="value"><?php echo e(translate($product->product_type)); ?></span>
                                </div>
                                <?php if($product->product_type == 'physical'): ?>
                                    <div>
                                        <span class="key text-nowrap text-capitalize"><?php echo e(translate('product_unit')); ?></span>
                                        <span>:</span>
                                        <span class="value"><?php echo e($product['unit']); ?></span>
                                    </div>
                                    <div>
                                        <span class="key text-nowrap"><?php echo e(translate('current_Stock')); ?></span>
                                        <span>:</span>
                                        <span class="value"><?php echo e($product->current_stock); ?></span>
                                    </div>
                                <?php endif; ?>
                                <div>
                                    <span class="key text-nowrap"><?php echo e(translate('product_SKU')); ?></span>
                                    <span>:</span>
                                    <span class="value"><?php echo e($product->code); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6 col-xl-4">
                            <h4 class="mb-3 text-capitalize"><?php echo e(translate('price_information')); ?></h4>
                            <div class="pair-list">
                                <div>
                                    <span class="key text-nowrap text-capitalize">
                                        <?php echo e(translate('unit_price')); ?>

                                    </span>
                                    <span>:</span>
                                    <span class="value">
                                        <?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: $product->unit_price), currencyCode: getCurrencyCode())); ?>

                                    </span>
                                </div>

                                <div>
                                    <span class="key text-nowrap"><?php echo e(translate('tax')); ?></span>
                                    <span>:</span>
                                    <?php if($product->tax_type =='percent'): ?>
                                        <span class="value">
                                            <?php echo e($product->tax); ?>% (<?php echo e($product->tax_model); ?>)
                                        </span>
                                    <?php else: ?>
                                        <span class="value">
                                            <?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: $product->tax))); ?> (<?php echo e($product->tax_model); ?>)
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <?php if($product->product_type == 'physical'): ?>
                                    <div>
                                        <span class="key text-nowrap text-capitalize">
                                            <?php echo e(translate('shipping_cost')); ?>

                                        </span>
                                        <span>:</span>
                                        <span class="value">
                                            <?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: $product->shipping_cost))); ?>

                                            <?php if($product->multiply_qty == 1): ?>
                                                (<?php echo e(translate('multiply_with_quantity')); ?>)
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                <?php endif; ?>
                                <?php if($product->discount > 0): ?>
                                    <div>
                                        <span class="key text-nowrap">
                                            <?php echo e(translate('discount')); ?>

                                        </span>
                                        <span>:</span>
                                        <?php if($product->discount_type == 'percent'): ?>
                                            <span class="value"><?php echo e($product->discount); ?>%</span>
                                        <?php else: ?>
                                            <span class="value">
                                                <?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: $product->discount), currencyCode: getCurrencyCode())); ?>

                                            </span>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if(count($product->tags)>0): ?>
                            <div class="col-sm-6 col-xl-4">
                                <h4 class="mb-3"><?php echo e(translate('tags')); ?></h4>
                                <div class="pair-list">
                                    <div>
                                        <span class="value">
                                            <?php $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo e($tag['tag']); ?>

                                                <?php if($key === (count($product->tags)-1)): ?>
                                                    <?php break; ?>
                                                <?php endif; ?>
                                                ,
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>


        </div>
        <div class="row g-2 mt-3">
            <?php if(!empty($product['variation']) && count(json_decode($product['variation'])) >0): ?>
                <div class="col-md-12">
                    <div class="card border-0">
                        <div class="card-body p-0">
                            <div class="table-responsive datatable-custom">
                                <table
                                    class="table table-borderless table-nowrap table-align-middle card-table w-100 text-start">
                                    <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th class="text-center"><?php echo e(translate('SKU')); ?></th>
                                        <th class="text-center text-capitalize"><?php echo e(translate('variation_wise_price')); ?></th>
                                        <th class="text-center"><?php echo e(translate('stock')); ?></th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = json_decode($product['variation']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center">
                                                <span class="py-1"><?php echo e($value->sku); ?></span>
                                            </td>
                                            <td class="text-center">
                                                <span class="py-1">
                                                    <?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: $value->price), currencyCode: getCurrencyCode())); ?>

                                                </span>
                                            </td>
                                            <td class="text-center">
                                                <span class="py-1"><?php echo e(($value->qty)); ?></span>
                                            </td>
                                            <td></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <?php if(!empty($product->digitalVariation) && count($product->digitalVariation) > 0): ?>
                <div class="col-md-12">
                    <div class="card border-0">
                        <div class="card-body p-0">
                            <div class="table-responsive datatable-custom">
                                <table
                                    class="table table-borderless table-nowrap table-align-middle card-table w-100 text-start">
                                    <thead class="thead-light thead-50 text-capitalize">
                                    <tr>
                                        <th class="text-center"><?php echo e(translate('SL')); ?></th>
                                        <th class="text-center"><?php echo e(translate('Variation_Name')); ?></th>
                                        <th class="text-center"><?php echo e(translate('SKU')); ?></th>
                                        <th class="text-center"><?php echo e(translate('price')); ?></th>
                                        <?php if($product->digital_product_type == 'ready_product'): ?>
                                            <th class="text-center"><?php echo e(translate('Action')); ?></th>
                                        <?php endif; ?>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $product->digitalVariation; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="text-center">
                                                <?php echo e($key+1); ?>

                                            </td>
                                            <td class="text-center text-capitalize">
                                                <span class="py-1"><?php echo e($variation->variant_key ?? '-'); ?></span>
                                            </td>
                                            <td class="text-center">
                                                <span class="py-1"><?php echo e($variation->sku); ?></span>
                                            </td>
                                            <td class="text-center">
                                                <span class="py-1">
                                                    <?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: $variation->price), currencyCode: getCurrencyCode())); ?>

                                                </span>
                                            </td>

                                            <?php if($product->digital_product_type == 'ready_product'): ?>
                                                <td class="text-center">
                                                    <span class="btn p-0 getDownloadFileUsingFileUrl" data-toggle="tooltip" title="<?php echo e(!is_null($variation->file_full_url['path']) ? translate('download') : translate('File_not_found')); ?>" data-file-path="<?php echo e($variation->file_full_url['path']); ?>" download>
                                                        <img src="<?php echo e(asset(path: 'public/assets/back-end/img/icons/download-green.svg')); ?>" alt="">
                                                    </span>
                                                </td>
                                            <?php endif; ?>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <div class="col-md-6">
                <div class="card h-100">
                    <div class="card-header bg--primary--light">
                        <h5 class="card-title text-capitalize"><?php echo e(translate('product_SEO_&_meta_data')); ?></h5>
                    </div>
                    <div class="card-body">
                        <div>
                            <h6 class="mb-3 text-capitalize">
                                <?php echo e($product?->seoInfo?->title ?? ( $product->meta_title ?? translate('meta_title_not_found').' '.'!')); ?>

                            </h6>
                        </div>
                        <p class="text-capitalize">
                            <?php echo e($product?->seoInfo?->description ?? ($product->meta_description ?? translate('meta_description_not_found').' '.'!')); ?>

                        </p>
                        <?php if($product?->seoInfo?->image_full_url['path'] || $product->meta_image_full_url['path']): ?>
                            <div class="d-flex flex-wrap gap-2">
                                <a class="aspect-1 float-left overflow-hidden"
                                   href="<?php echo e(getStorageImages(path:$product?->seoInfo?->image_full_url['path'] ? $product?->seoInfo?->image_full_url : $product->meta_image_full_url,type: 'backend-basic')); ?>"
                                   data-lightbox="meta-thumbnail">
                                    <img class="max-width-100px"
                                         src="<?php echo e(getStorageImages(path:$product?->seoInfo?->image_full_url['path'] ? $product?->seoInfo?->image_full_url : $product->meta_image_full_url,type: 'backend-basic')); ?>" alt="<?php echo e(translate('meta_image')); ?>">
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card h-100">
                    <div class="card-header bg--primary--light">
                        <h5 class="card-title text-capitalize"><?php echo e(translate('product_video')); ?></h5>
                    </div>
                    <div class="card-body">
                        <div>
                            <h6 class="mb-3 text-capitalize">
                                <?php echo e($product['video_provider'].' '.translate('video_link')); ?>

                            </h6>
                        </div>
                        <?php if($product['video_url'] ): ?>
                            <a href="<?php echo e((str_contains($product->video_url, "https://") || str_contains($product->video_url, "http://")) ? $product['video_url'] : "javascript:"); ?>" target="_blank"
                               class="text-primary <?php echo e((str_contains($product->video_url, "https://") || str_contains($product->video_url, "http://"))?'' : 'cursor-default'); ?>">
                                <?php echo e($product['video_url']); ?>

                            </a>
                        <?php else: ?>
                            <span><?php echo e(translate('no_data_to_show').' '.'!'); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php if($product->denied_note && $product['request_status'] == 2): ?>
                <div class="col-md-12">
                    <div class="card h-100">
                        <div class="card-header bg--primary--light">
                            <h5 class="card-title text-capitalize"><?php echo e(translate('reject_reason')); ?></h5>
                        </div>
                        <div class="card-body">
                            <div>
                                <?php echo e($product->denied_note); ?>

                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="card mt-3">
            <?php ($vendorReviewReplyStatus = getWebConfig('vendor_review_reply_status') ?? 0); ?>
            <div class="table-responsive datatable-custom">
                <table
                    class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100 text-start">
                    <thead class="thead-light thead-50 text-capitalize">
                    <tr>
                        <th><?php echo e(translate('SL')); ?></th>
                        <th><?php echo e(translate('Review_ID')); ?></th>
                        <th><?php echo e(translate('reviewer')); ?></th>
                        <th><?php echo e(translate('rating')); ?></th>
                        <th><?php echo e(translate('review')); ?></th>
                        <?php if($vendorReviewReplyStatus): ?>
                            <th><?php echo e(translate('Reply')); ?></th>
                        <?php endif; ?>
                        <th class="text-center"><?php echo e(translate('date')); ?></th>
                        <th class="text-center"><?php echo e(translate('Status')); ?></th>
                        <th class="text-center"><?php echo e(translate('action')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(isset($review->customer)): ?>
                            <tr>
                                <td><?php echo e($reviews->firstItem()+$key); ?></td>
                                <td class="text-center">
                                    <?php echo e($review->id); ?>

                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar rounded">
                                            <img class="avatar-img"
                                                 src="<?php echo e(getStorageImages(path:$review->customer->image_full_url,type: 'backend-profile')); ?>"
                                                 alt="">
                                        </div>
                                        <div class="<?php echo e(Session::get('direction') === "rtl" ? 'mr-3' : 'ml-3'); ?>">
                                            <span class="d-block h5 text-hover-primary mb-0">
                                                <?php echo e($review->customer['f_name']." ".$review->customer['l_name']); ?>

                                                <i class="tio-verified text-primary" data-toggle="tooltip"
                                                   data-placement="top" title="Verified Customer"></i>
                                            </span>
                                            <span class="d-block font-size-sm text-body">
                                                <?php echo e($review->customer->email ?? ""); ?>

                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center gap-2 text-primary">
                                        <i class="tio-star"></i>
                                        <span><?php echo e($review->rating); ?></span>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-wrap max-w-400 min-w-200">
                                        <p>
                                            <?php echo e($review['comment']); ?>

                                        </p>
                                        <?php if(count($review->attachment_full_url) > 0): ?>
                                            <?php $__currentLoopData = $review->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class="aspect-1 float-left overflow-hidden"
                                                   href="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>"
                                                   data-lightbox="review-gallery<?php echo e($review['id']); ?>" >
                                                    <img class="p-2" width="60" height="60"
                                                         src="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>" alt="<?php echo e(translate('review_image')); ?>">
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </td>
                                <?php if($vendorReviewReplyStatus): ?>
                                <td>
                                    <div class="line--limit-2 max-w-250 word-break">
                                        <?php echo e($review?->reply?->reply_text ?? '-'); ?>

                                    </div>
                                </td>
                                <?php endif; ?>
                                <td class="text-center">
                                    <?php echo e(date('d M Y H:i:s', strtotime($review['created_at']))); ?>

                                </td>
                                <td>
                                    <form
                                        action="<?php echo e(route('vendor.reviews.update-status', [$review['id'], $review->status ? 0 : 1])); ?>"
                                        method="get" id="reviews-status<?php echo e($review['id']); ?>-form">
                                        <label class="switcher mx-auto">
                                            <input type="checkbox" class="switcher_input toggle-switch-message"
                                                   name="status"
                                                   id="reviews-status<?php echo e($review['id']); ?>" value="1"
                                                   <?php echo e($review['status'] == 1 ? 'checked' : ''); ?>

                                                   data-modal-id="toggle-status-modal"
                                                   data-toggle-id="reviews-status<?php echo e($review['id']); ?>"
                                                   data-on-image="customer-reviews-on.png"
                                                   data-off-image="customer-reviews-off.png"
                                                   data-on-title="<?php echo e(translate('Want_to_Turn_ON_Customer_Reviews')); ?>"
                                                   data-off-title="<?php echo e(translate('Want_to_Turn_OFF_Customer_Reviews')); ?>"
                                                   data-on-message="<p><?php echo e(translate('if_enabled_anyone_can_see_this_review_on_the_user_website_and_customer_app')); ?></p>"
                                                   data-off-message="<p><?php echo e(translate('if_disabled_this_review_will_be_hidden_from_the_user_website_and_customer_app')); ?></p>">
                                            <span class="switcher_control"></span>
                                        </label>
                                    </form>
                                </td>
                                <td>
                                    <div class="d-flex gap-2 justify-content-center">
                                        <div data-toggle="modal" data-target="#review-view-for-<?php echo e($review['id']); ?>">
                                            <a class="btn btn-outline-info btn-sm square-btn" title="<?php echo e(translate('View')); ?>" data-toggle="tooltip">
                                                <i class="tio-invisible"></i>
                                            </a>
                                        </div>

                                        <?php if($vendorReviewReplyStatus): ?>
                                            <div data-toggle="modal" data-target="#review-update-for-<?php echo e($review['id']); ?>">
                                                <?php if($review?->reply): ?>
                                                    <a class="btn btn-outline-primary btn-sm square-btn" title="<?php echo e(translate('Update_Review')); ?>" data-toggle="tooltip">
                                                        <i class="tio-edit"></i>
                                                    </a>
                                                <?php else: ?>
                                                    <div class="btn btn-outline--primary btn-sm square-btn" title="<?php echo e(translate('Review_Reply')); ?>" data-toggle="tooltip">
                                                        <i class="tio-reply-all"></i>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($review->customer)): ?>
                    <div class="modal fade" id="review-update-for-<?php echo e($review['id']); ?>" tabindex="-1" aria-labelledby="exampleModalLabel"
                         aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close text-BFBFBF" data-dismiss="modal" aria-label="Close">
                                        <i class="tio-clear-circle"></i>
                                    </button>
                                </div>
                                <form method="POST" action="<?php echo e(route('vendor.reviews.add-review-reply')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <div class="modal-body pt-0">
                                        <div class="d-flex flex-wrap gap-3 mb-3">
                                            <img src="<?php echo e(getStorageImages(path: $product->thumbnail_full_url, type: 'backend-product')); ?>" width="120" class="rounded aspect-1 border" alt="">
                                            <div class="w-0 flex-grow-1 font-weight-semibold">
                                                <?php if($review['order_id']): ?>
                                                    <div class="mb-2">
                                                        <?php echo e(translate('Order_ID')); ?> # <?php echo e($review['order_id']); ?>

                                                    </div>
                                                <?php endif; ?>
                                                <h4><?php echo e($translate[$language]['name'] ?? $product['name']); ?></h4>
                                            </div>
                                        </div>
                                        <label class="input-label text--title font-weight-bold">
                                            <?php echo e(translate('Review')); ?>

                                        </label>
                                        <div class="__bg-F3F5F9 p-3 rounded border mb-2">
                                            <?php echo e($review['comment']); ?>

                                        </div>
                                        <div class="d-flex flex-wrap gap-2">
                                            <?php if(count($review->attachment_full_url) > 0): ?>
                                                <?php $__currentLoopData = $review->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a class="aspect-1 float-left overflow-hidden"
                                                       href="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>"
                                                       data-lightbox="review-gallery-modal<?php echo e($review['id']); ?>" >
                                                        <img width="45" class="rounded aspect-1 border"
                                                             src="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>"
                                                             alt="<?php echo e(translate('review_image')); ?>">
                                                    </a>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        </div>
                                        <label class="input-label text--title font-weight-bold pt-4">
                                            <?php echo e(translate('Reply')); ?>

                                        </label>
                                        <input type="hidden" name="review_id" value="<?php echo e($review['id']); ?>">
                                        <textarea class="form-control text-area-max-min" rows="3" name="reply_text"
                                                  placeholder="<?php echo e(translate('Write_the_reply_of_the_product_review')); ?>..."><?php echo e($review?->reply?->reply_text ?? ''); ?></textarea>
                                        <div class="text-right mt-4">
                                            <button type="submit" class="btn btn--primary">
                                                <?php if($review?->reply?->reply_text): ?>
                                                    <?php echo e(translate('Update')); ?>

                                                <?php else: ?>
                                                    <?php echo e(translate('submit')); ?>

                                                <?php endif; ?>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                    <div class="modal fade" id="review-view-for-<?php echo e($review['id']); ?>" tabindex="-1" aria-labelledby="exampleModalLabel"
                         aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <button type="button" class="close text-BFBFBF" data-dismiss="modal" aria-label="Close">
                                        <i class="tio-clear-circle"></i>
                                    </button>
                                </div>
                                <div class="modal-body pt-0">
                                    <div class="d-flex flex-wrap align-items-center gap-3 mb-3 text-center border-bottom">
                                        <div class="w-0 flex-grow-1 font-weight-semibold">
                                            <div class="mb-2">
                                                <?php echo e(translate('Review_ID')); ?> # <?php echo e($review['id']); ?>

                                            </div>

                                            <?php if($review['order_id']): ?>
                                                <div class="mb-2">
                                                    <?php echo e(translate('Order_ID')); ?> # <?php echo e($review['order_id']); ?>

                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <h2 class="text-center">
                                        <span class="text-primary"><?php echo e($review['rating'].'.0'); ?></span><span class="fz-16 text-muted"><?php echo e('/5'); ?></span>
                                    </h2>
                                    <div class="d-flex align-items-center gap-1 text-primary justify-content-center fz-14 mb-4">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($i <= $review['rating']): ?>
                                                <i class="tio-star"></i>
                                            <?php else: ?>
                                                <i class="tio-star-outlined"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>

                                    <label class="input-label text--title font-weight-bold">
                                        <?php echo e(translate('Review')); ?>

                                    </label>
                                    <div class="__bg-F3F5F9 p-3 rounded border mb-2">
                                        <?php echo e($review['comment']); ?>

                                    </div>
                                    <div class="d-flex flex-wrap gap-2">
                                        <?php if(count($review->attachment_full_url) > 0): ?>
                                            <?php $__currentLoopData = $review->attachment_full_url; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a class="aspect-1 float-left overflow-hidden"
                                                   href="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>"
                                                   data-lightbox="review-gallery-modal<?php echo e($review['id']); ?>" >
                                                    <img width="45" class="rounded aspect-1 border"
                                                         src="<?php echo e(getStorageImages(path: $img,type: 'backend-basic')); ?>"
                                                         alt="<?php echo e(translate('review_image')); ?>">
                                                </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($review?->reply?->reply_text): ?>
                                        <label class="input-label text--title font-weight-bold pt-4">
                                            <?php echo e(translate('Reply')); ?>

                                        </label>
                                        <div class="__bg-F3F5F9 p-3 rounded border mb-2">
                                            <?php echo e($review?->reply?->reply_text ?? ''); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="table-responsive mt-4">
                <div class="px-4 d-flex justify-content-lg-end">
                    <?php echo $reviews->links(); ?>

                </div>
            </div>

            <?php if(count($reviews)==0): ?>
                <?php echo $__env->make('layouts.back-end._empty-state',['text'=>'no_review_found'],['image'=>'default'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        $(".lang-link").click(function (e) {
            e.preventDefault();
            $('.lang-link').removeClass('active');
            $(".lang-form").addClass('d-none');
            $(this).addClass('active');
            let formId = this.id;
            let lang = formId.split("-")[0];
            $("#" + lang + "-form").removeClass('d-none');
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app-seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/sdmkinga/tupatane.store/resources/views/vendor-views/product/view.blade.php ENDPATH**/ ?>