<html>
    <table>
        <thead>
            <tr>
                <th style="font-size: 18px"><?php echo e(translate($data['type'].'_product_List')); ?></th>
            </tr>
            <tr>

                <th><?php echo e(translate('filter_Criteria').' - '); ?></th>
                <th></th>
                <th>
                    <?php if(isset($data['vendor'])): ?>
                        <?php echo e(translate('store_Name')); ?> - <?php echo e($data['vendor']?->shop?->name); ?>

                        <br>
                    <?php endif; ?>
                    <?php echo e(translate('category').' - '. ($data['category'] != 'all' ? $data['category']['defaultName'] : $data['category'])); ?>

                    <br>
                    <?php echo e(translate('sub_Category').' - '. ($data['sub_category'] != 'all' ? $data['sub_category']['defaultName'] : $data['sub_category'])); ?>

                    <br>
                    <?php echo e(translate('sub_Sub_Category').' - '. ($data['sub_sub_category'] != 'all' ? $data['sub_sub_category']['defaultName'] : $data['sub_sub_category'])); ?>

                    <br>
                    <?php echo e(translate('brand').' - '. ($data['brand'] != 'all' ? $data['brand']['defaultName'] : $data['brand'])); ?>


                    <?php if($data['type']=='seller'): ?>
                        <br>
                        <?php echo e(translate('store').' - '. ($data['seller']?->shop->name ?? translate('all'))); ?>

                        <br>
                        <?php echo e(translate('status').' - '. ($data['status']==0 ? translate('pending') : ($data['status'] == 1 ? translate('approved') : translate('denied')) )); ?>

                    <?php endif; ?>
                    <br>
                    <?php echo e(translate('search_Bar_Content').' - '. (!empty($data['searchValue']) ?  ucwords($data['searchValue']) : 'N/A')); ?>


                </th>
            </tr>
            <tr>
                <td> <?php echo e(translate('SL')); ?></td>
                <td> <?php echo e(translate('product_Image')); ?>	</td>
                <td> <?php echo e(translate('image_URL')); ?>	</td>
                <td> <?php echo e(translate('product_Name')); ?>	</td>
                <td> <?php echo e(translate('product_SKU')); ?></td>
                <td> <?php echo e(translate('description')); ?></td>

                <td>
                    <?php if($data['type']=='seller'): ?>
                        <?php echo e(translate('store_Name')); ?>

                    <?php endif; ?>
                </td>
                <td> <?php echo e(translate('category_Name')); ?></td>
                <td> <?php echo e(translate('sub_Category_Name')); ?></td>
                <td> <?php echo e(translate('sub_Sub_Category_Name')); ?></td>
                <td> <?php echo e(translate('brand')); ?></td>
                <td> <?php echo e(translate('product_Type')); ?></td>
                <td> <?php echo e(translate('price')); ?></td>
                <td> <?php echo e(translate('tax')); ?></td>
                <td> <?php echo e(translate('discount')); ?></td>
                <td> <?php echo e(translate('discount_Type')); ?></td>
                <td> <?php echo e(translate('rating')); ?></td>
                <td> <?php echo e(translate('product_Tags')); ?></td>
                <td> <?php echo e(translate('status')); ?></td>
            </tr>
            <?php $__currentLoopData = $data['products']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td> <?php echo e(++$key); ?>	</td>
                    <td style="height: 200px"></td>
                    <td><?php echo e(dynamicStorage(path: 'storage/app/public/product/thumbnail/'.$item->thumbnail)); ?></td>
                    <td> <?php echo e($item->name); ?></td>
                    <td><?php echo e($item->code); ?></td>
                    <td><?php echo e(strip_tags(str_replace('&nbsp;', ' ', $item->details))); ?></td>
                    <td>
                        <?php if($data['type']=='seller'): ?>
                        <?php echo e(ucwords($item?->seller?->shop->name ?? translate('not_found'))); ?>

                        <?php endif; ?>
                    </td>
                    <td><?php echo e($item?->category->name ?? 'N/A'); ?></td>
                    <td><?php echo e($item?->subCategory->name ?? 'N/A'); ?></td>
                    <td><?php echo e($item?->subSubCategory->name ?? 'N/A'); ?></td>
                    <td><?php echo e($item?->brand->name ?? 'N/A'); ?></td>
                    <td><?php echo e($item?->product_type); ?></td>
                    <td><?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency($item['unit_price'] ?? 0), currencyCode: getCurrencyCode())); ?></td>
                    <td><?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency($item['tax'] ?? 0), currencyCode: getCurrencyCode())); ?></td>
                    <td><?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency($item['discount'] ?? 0), currencyCode: getCurrencyCode())); ?></td>
                    <td><?php echo e($item->discount_type); ?></td>
                    <td><?php echo e($item?->rating && count($item->rating) > 0 ?  number_format($item->rating[0]->average,2) : 'N/A'); ?></td>
                    <td>
                        <?php if($item->tags): ?>
                            <?php $__currentLoopData = $item->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php echo e($tag->tag); ?>,
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </td>
                    <td> <?php echo e(translate($item->status == 1 ? 'active' : 'inactive')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </thead>
    </table>
</html>
<?php /**PATH /home/tupatane/public_html/resources/views/file-exports/product-list.blade.php ENDPATH**/ ?>