<?php $__env->startSection('title', translate('SEO_Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex justify-content-between align-items-center gap-3 mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/seo-settings.svg')); ?>" alt="">
                <?php echo e(translate('SEO_Settings')); ?>

            </h2>
        </div>
        <?php echo $__env->make('admin-views.business-settings.seo-settings._inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card shadow-none">
            <div class="card-header flex-wrap gap-2">
                <div class="">
                    <h4 class="title m-0"><?php echo e(translate('404 Logs')); ?></h4>
                    <p class="m-0">
                        <?php echo e(translate('track_instances_of_page_not_found_errors_faced_by_users_on_your_website')); ?>

                        <a href="<?php echo e('https://6amtech.com/blog/404-logs/'); ?>" target="_blank" class="text-primary text-underline font-weight-semibold">
                            <?php echo e(translate('Learn_more')); ?>

                        </a>
                    </p>
                </div>
                <div>
                    <button type="button"  class="btn bg-soft-danger text-danger border border-danger text-capitalize delete-data d-none <?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>" id="clear-all-log" data-id="delete-selected-error-logs"><?php echo e(translate('clear_all_log')); ?></button>
                    <form action="<?php echo e(env('APP_MODE') !='demo' ? route('admin.error-logs.delete-selected-error-logs') : 'javascript:'); ?>"
                          method="post" id="delete-selected-error-logs" >
                        <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                        <div id="selected-ids"></div>
                    </form>
                </div>
            </div>
            <div class="card-body px-0">
                <div class="table-responsive">
                    <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table dataTable no-footer table-hover d-lg-table">
                        <thead class="thead-light">
                        <tr>
                            <th class="w-95px">
                                <div class="d-flex align-items-center gap-2">
                                    <span class="check-item-2">
                                        <input type="checkbox" id="master-check-box">
                                    </span>
                                    <span><?php echo e(translate('URL')); ?></span>
                                </div>
                            </th>
                            <th class="w-45px text-center"><?php echo e(translate('hits')); ?></th>
                            <th class="w-200px text-center text-capitalize"><?php echo e(translate('last_hit_date')); ?></th>
                            <th class="w-200px text-center text-capitalize"><?php echo e(translate('redirection_link')); ?></th>
                            <th class="text-center w-60px"><?php echo e(translate('action')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $errorLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$errorLog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center gap-2 overflow-hidden text-wrap">
                                    <span class="check-item-2">
                                        <input type="checkbox" class="row-check-box" value="<?php echo e($errorLog['id']); ?>">
                                    </span>
                                        <a href="javascript:" class="text-primary text-underline"><?php echo e($errorLog['url']); ?></a>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <span class="font-weight-semibold text-title"><?php echo e($errorLog['hit_counts']); ?></span>
                                </td>
                                <td class="text-center">
                                    <span><?php echo e(date('M y', $errorLog['update_at'])); ?> <small><?php echo e(date('h:i A',$errorLog['update_at'])); ?></small></span>
                                </td>
                                <td>
                                    <?php if($errorLog['redirect_url']): ?>
                                        <div class="d-flex flex-wrap justify-content-center">
                                            <button class="btn edit-content-btn text-capitalize edit-redirect-link" data-id="<?php echo e($errorLog['id']); ?>"
                                                data-redirect-url="<?php echo e($errorLog['redirect_url']); ?>"
                                                data-redirect-status="<?php echo e($errorLog['redirect_status']); ?>"
                                            >
                                                <i class="tio-edit"></i> <?php echo e(translate('edit_link')); ?>

                                            </button>
                                        </div>
                                    <?php else: ?>
                                        <div class="d-flex flex-wrap justify-content-center">
                                            <button class="btn add-content-btn text-capitalize add-redirect-link" data-id="<?php echo e($errorLog['id']); ?>">
                                                <i class="tio-add"></i> <?php echo e(translate('add_link')); ?>

                                            </button>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="d-flex flex-wrap justify-content-center ">
                                        <a class="<?php echo e(env('APP_MODE')!='demo'? 'delete-data' : 'call-demo'); ?>" href="javascript:" data-id="error-logs-<?php echo e($errorLog['id']); ?>">
                                            <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/delete-outlined.png')); ?>" alt="" width="30">
                                        </a>
                                    </div>
                                    <form action="<?php echo e(route('admin.error-logs.index',['id'=>$errorLog['id']])); ?>"
                                          method="post" id="error-logs-<?php echo e($errorLog['id']); ?>">
                                        <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <div class="page-area px-4 pt-4">
                    <div class="d-flex align-items-center justify-content-end">
                        <div>
                            <?php echo e($errorLogs->links()); ?>

                        </div>
                    </div>
                </div>
                <?php if(count($errorLogs) == 0): ?>
                    <?php echo $__env->make('layouts.back-end._empty-state',['text'=>'no_error_logs_data_found'],['image'=>'default'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="modal fade" id="add-edit-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form action="<?php echo e(route('admin.error-logs.index')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <input name="id" hidden>
                    <div class="modal-header">
                        <h3 class="modal-title w-100 text-center"><?php echo e(translate('redirection_link')); ?></h3>
                        <button type="button" class="position-absolute right-0 top-2 bg-transparent border-0 p-3 opacity--40 fz-16" data-dismiss="modal">
                            <i class="tio-clear-circle"></i>
                        </button>
                    </div>
                    <div class="modal-body">
                        <label class="form-label"><?php echo e(translate('redirection_link')); ?></label>
                        <input type="text" class="form-control" name="redirect_url" placeholder="<?php echo e(translate('enter_you_link')); ?>">

                        <label class="form-label mt-3"><?php echo e(translate('Status')); ?></label>
                        <div class="form-group d-flex gap-4 align-items-center">
                            <div class="custom-control custom-radio d-flex align-items-center">
                                <input type="radio" class="custom-control-input" value="301"
                                       name="redirect_status"
                                       id="logs_redirect_status_301">
                                <label class="custom-control-label"
                                       for="logs_redirect_status_301">
                                    <?php echo e('301'); ?>

                                </label>
                            </div>
                            <div class="custom-control custom-radio d-flex align-items-center">
                                <input type="radio" class="custom-control-input" value="302"
                                       name="redirect_status"
                                       id="logs_redirect_status_302">
                                <label class="custom-control-label"
                                       for="logs_redirect_status_302">
                                    <?php echo e('302'); ?>

                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-0 pt-0">
                        <button type="<?php echo e(env('APP_MODE') == 'demo' ? 'button' : 'submit'); ?>" class="btn btn--primary submit-button <?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>"><?php echo e(translate('submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/js/admin/error-logs.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/sdmkinga/tupatane.store/resources/views/admin-views/business-settings/seo-settings/error-logs.blade.php ENDPATH**/ ?>