<?php $__env->startSection('title', translate('my_Address')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <link rel="stylesheet" href="<?php echo e(theme_asset(path: 'public/assets/front-end/vendor/nouislider/distribute/nouislider.min.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(theme_asset(path: 'public/assets/front-end/css/bootstrap-select.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(theme_asset(path: 'public/assets/front-end/css/address.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(theme_asset(path: 'public/assets/front-end/plugin/intl-tel-input/css/intlTelInput.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container py-4 rtl __account-address text-align-direction">

    <div class="row g-3">
        <?php echo $__env->make('web-views.partials._profile-aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <section class="col-lg-9 col-md-8">

            <div class="card">
                <div class="card-body">
                    <h5 class="font-bold m-0 fs-16"><?php echo e(translate('Update_Addresses')); ?></h5>
                    <form action="<?php echo e(route('address-update')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row pb-1">
                            <div class="col-md-6">
                                <input type="hidden" name="id" value="<?php echo e($shippingAddress->id); ?>">
                                <ul class="donate-now d-flex gap-2">
                                    <li class="address_type_li">
                                        <input type="radio" class="address_type" id="a25" name="addressAs" value="permanent"  <?php echo e($shippingAddress->address_type == 'permanent' ? 'checked' : ''); ?> />
                                        <label for="a25" class="component"><?php echo e(translate('permanent')); ?></label>
                                    </li>
                                    <li class="address_type_li">
                                        <input type="radio" class="address_type" id="a50" name="addressAs" value="home" <?php echo e($shippingAddress->address_type == 'home' ? 'checked' : ''); ?> />
                                        <label for="a50" class="component"><?php echo e(translate('home')); ?></label>
                                    </li>
                                    <li class="address_type_li">
                                        <input type="radio" class="address_type" id="a75" name="addressAs" value="office" <?php echo e($shippingAddress->address_type == 'office' ? 'checked' : ''); ?>/>
                                        <label for="a75" class="component"><?php echo e(translate('office')); ?></label>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <input type="hidden" id="is_billing" value="<?php echo e($shippingAddress->is_billing); ?>">
                                <ul class="donate-now d-flex gap-2">
                                    <li class="address_type_bl">
                                        <input type="radio" class="bill_type" id="b25" name="is_billing" value="0"  <?php echo e($shippingAddress->is_billing == '0' ? 'checked' : ''); ?> />
                                        <label for="b25" class="component"><?php echo e(translate('shipping')); ?></label>
                                    </li>
                                    <li class="address_type_bl">
                                        <input type="radio" class="bill_type" id="b50" name="is_billing" value="1" <?php echo e($shippingAddress->is_billing == '1' ? 'checked' : ''); ?> />
                                        <label for="b50" class="component"><?php echo e(translate('billing')); ?></label>
                                    </li>

                                </ul>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="person_name"><?php echo e(translate('contact_person_name')); ?></label>
                                <input class="form-control" type="text" id="person_name"
                                    name="name"
                                    value="<?php echo e($shippingAddress->contact_person_name); ?>"
                                    required>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="own_phone"><?php echo e(translate('phone')); ?></label>
                                <input class="form-control phone-input-with-country-picker" type="text" id="own_phone" value="+<?php echo e($shippingAddress->phone); ?>" required="required">
                                <input type="hidden" class="country-picker-phone-number w-50" name="phone" value="<?php echo e($shippingAddress->phone); ?>" readonly>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="city"><?php echo e(translate('city')); ?></label>

                                <input class="form-control" type="text" id="city" name="city" value="<?php echo e($shippingAddress->city); ?>" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="zip_code"><?php echo e(translate('zip_code')); ?></label>
                                <?php if($zip_restrict_status): ?>
                                    <select name="zip" class="form-control selectpicker" data-live-search="true" id="" required>
                                        <?php $__currentLoopData = $delivery_zipcodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $zip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($zip->zipcode); ?>" <?php echo e($zip->zipcode == $shippingAddress->zip? 'selected' : ''); ?>><?php echo e($zip->zipcode); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                <?php else: ?>
                                    <input class="form-control" type="text" id="zip_code" name="zip" value="<?php echo e($shippingAddress->zip); ?>" required>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <label for="city"><?php echo e(translate('country')); ?></label>
                                <select name="country" class="form-control selectpicker" data-live-search="true" id="" required>
                                    <?php if($country_restrict_status): ?>
                                        <?php $__currentLoopData = $delivery_countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country['name']); ?>" <?php echo e($country['name'] == $shippingAddress->country? 'selected' : ''); ?>><?php echo e($country['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <?php $__currentLoopData = COUNTRIES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country['name']); ?>" <?php echo e($shippingAddress->country == $country['name']? 'selected' : ''); ?>><?php echo e($country['name']); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class=" col-md-12">
                                <div class="form-group mb-1">
                                    <label for="own_address"><?php echo e(translate('address')); ?></label>
                                    <textarea class="form-control" id="address"
                                              type="text"  name="address" required><?php echo e($shippingAddress->address); ?></textarea>
                                    <span class="fs-14 text-danger font-semi-bold opacity-0 map-address-alert">
                                        <?php echo e(translate('note')); ?>: <?php echo e(translate('you_need_to_select_address_from_your_selected_country')); ?>

                                    </span>
                                </div>
                            </div>
                            <?php if(getWebConfig('map_api_status') ==1 ): ?>
                                <div class="col-md-12">
                                    <div class="form-group map-area-alert-border location-map-address-canvas-area">
                                        <input id="pac-input" class="controls rounded __inline-46 location-search-input-field" title="<?php echo e(translate('search_your_location_here')); ?>" type="text" placeholder="<?php echo e(translate('search_here')); ?>"/>
                                        <div class="__h-200px" id="location_map_canvas"></div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <?php ($shipping_latitude=$shippingAddress->latitude); ?>
                        <?php ($shipping_longitude=$shippingAddress->longitude); ?>
                        <input type="hidden" id="latitude"
                            name="latitude" class="form-control d-inline"
                            placeholder="<?php echo e(translate('ex')); ?> : -94.22213" value="<?php echo e($shipping_latitude??0); ?>" required readonly>
                        <input type="hidden"
                            name="longitude" class="form-control"
                            placeholder="<?php echo e(translate('ex')); ?> : 103.344322" id="longitude" value="<?php echo e($shipping_longitude??0); ?>" required readonly>
                        <div class="modal-footer">
                            <a href="<?php echo e(route('account-address')); ?>" class="closeB btn btn-secondary fs-14 font-semi-bold py-2 px-4"><?php echo e(translate('close')); ?></a>
                            <button type="submit" class="btn btn--primary fs-14 font-semi-bold py-2 px-4"><?php echo e(translate('update')); ?>  </button>
                        </div>
                    </form>
                </div>
            </div>

        </section>
    </div>
</div>
<span id="system-country-restrict-status" data-value="<?php echo e($country_restrict_status); ?>"></span>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    'use strict'
    const deliveryRestrictedCountries = <?php echo json_encode($countriesName, 15, 512) ?>;
    function deliveryRestrictedCountriesCheck(countryOrCode, elementSelector, inputElement) {
        const foundIndex = deliveryRestrictedCountries.findIndex(country => country.toLowerCase() === countryOrCode.toLowerCase());
        if (foundIndex !== -1) {
            $(elementSelector).removeClass('map-area-alert-danger');
            $(inputElement).parent().find('.map-address-alert').removeClass('opacity-100').addClass('opacity-0')
        } else {
            $(elementSelector).addClass('map-area-alert-danger');
            $(inputElement).val('')
            $(inputElement).parent().find('.map-address-alert').removeClass('opacity-0').addClass('opacity-100')
        }
    }
</script>
<script src="<?php echo e(theme_asset(path: 'public/assets/front-end/js/bootstrap-select.min.js')); ?>"></script>
<script src="<?php echo e(theme_asset(path: 'public/assets/front-end/plugin/intl-tel-input/js/intlTelInput.js')); ?>"></script>
<script src="<?php echo e(theme_asset(path: 'public/assets/front-end/js/country-picker-init.js')); ?>"></script>
<?php if(getWebConfig('map_api_status') ==1 ): ?>
    <script
        src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(getWebConfig('map_api_key')); ?>&callback=callBackFunction&loading=async&libraries=places&v=3.56" defer>
    </script>
    <script>
        async function initAutocomplete() {
            var myLatLng = { lat: <?php echo e($shipping_latitude??'-33.8688'); ?>, lng: <?php echo e($shipping_longitude??'151.2195'); ?> };
            const { Map } = await google.maps.importLibrary("maps");
            const { AdvancedMarkerElement } = await google.maps.importLibrary("marker");
            const map = new google.maps.Map(document.getElementById("location_map_canvas"), {
                center: { lat: <?php echo e($shipping_latitude??'-33.8688'); ?>, lng: <?php echo e($shipping_longitude??'151.2195'); ?> },
                zoom: 13,
                mapId: 'roadmap'
            });

            var marker = new AdvancedMarkerElement({
                map,
                position: myLatLng,
            });

            marker.setMap( map );
            var geocoder = geocoder = new google.maps.Geocoder();
            google.maps.event.addListener(map, 'click', function (mapsMouseEvent) {
                var coordinates = JSON.stringify(mapsMouseEvent.latLng.toJSON(), null, 2);
                var coordinates = JSON.parse(coordinates);
                var latlng = new google.maps.LatLng( coordinates['lat'], coordinates['lng'] ) ;
                marker.position={lat:coordinates['lat'], lng:coordinates['lng']};
                map.panTo( latlng );

                document.getElementById('latitude').value = coordinates['lat'];
                document.getElementById('longitude').value = coordinates['lng'];

                geocoder.geocode({ 'latLng': latlng }, function (results, status) {
                    if (status == google.maps.GeocoderStatus.OK) {
                        if (results[1]) {
                            document.getElementById('address').value = results[1].formatted_address;

                            let systemCountryRestrictStatus = $('#system-country-restrict-status').data('value');
                            if (systemCountryRestrictStatus) {
                                const countryObject = findCountryObject(results[1].address_components);
                                deliveryRestrictedCountriesCheck(countryObject.long_name, '.location-map-address-canvas-area', '#address')
                            }
                        }
                    }
                });
            });

            const input = document.getElementById("pac-input");
            const searchBox = new google.maps.places.SearchBox(input);
            map.controls[google.maps.ControlPosition.TOP_CENTER].push(input);
            map.addListener("bounds_changed", () => {
                searchBox.setBounds(map.getBounds());
            });
            let markers = [];

            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();

                if (places.length == 0) {
                    return;
                }

                markers.forEach((marker) => {
                    marker.setMap(null);
                });
                markers = [];
                const bounds = new google.maps.LatLngBounds();
                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) {
                        console.log("Returned place contains no geometry");
                        return;
                    }
                    var mrkr = new AdvancedMarkerElement({
                        map,
                        title: place.name,
                        position: place.geometry.location,
                    });

                    google.maps.event.addListener(mrkr, "click", function (event) {
                        document.getElementById('latitude').value = this.position.lat();
                        document.getElementById('longitude').value = this.position.lng();
                    });

                    markers.push(mrkr);

                    if (place.geometry.viewport) {
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }
                });
                map.fitBounds(bounds);
            });
        }
        function callBackFunction(){
            initAutocomplete();
        }

        $(document).on("keydown", "input", function(e) {
            if (e.which==13) e.preventDefault();
        });
    </script>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/kariakooyetu/public_html/resources/themes/default/web-views/users-profile/account-address-edit.blade.php ENDPATH**/ ?>