<?php $__env->startSection('title', translate('all_Categories')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta property="og:image" content="<?php echo e($web_config['web_logo']['path']); ?>"/>
    <meta property="og:title" content="Categories of <?php echo e($web_config['name']->value); ?> "/>
    <meta property="og:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="og:description"
          content="<?php echo e(substr(strip_tags(str_replace('&nbsp;', ' ', $web_config['about']->value)),0,160)); ?>">
    <meta property="twitter:card" content="<?php echo e($web_config['web_logo']['path']); ?>"/>
    <meta property="twitter:title" content="Categories of <?php echo e($web_config['name']->value); ?>"/>
    <meta property="twitter:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="twitter:description"
          content="<?php echo e(substr(strip_tags(str_replace('&nbsp;', ' ', $web_config['about']->value)),0,160)); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container rtl __inline-52 text-align-direction">

        <div class="bg-primary-light rounded-10 my-4 p-3 p-sm-4"
             data-bg-img="<?php echo e(theme_asset(path: 'public/assets/front-end/img/media/bg.png')); ?>">
            <div class="d-flex flex-column gap-1 text-primary">
                <h4 class="mb-0 text-start fw-bold text-primary text-uppercase">
                    <?php echo e(translate('category')); ?>

                </h4>
                <p class="fs-14 fw-semibold mb-0">
                    <?php echo e(translate('Find_your_favourite_categories_and_products')); ?>

                </p>
            </div>
        </div>

        <div class="brand_div-wrap mb-4">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categoryKey => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <a href="<?php echo e(route('products',['category_id'=> $category['id'],'data_from'=>'category','page'=>1])); ?>" class="brand_div">
                <img src="<?php echo e(getStorageImages(path: $category->icon_full_url, type: 'category')); ?>" alt="<?php echo e($category['name']); ?>">
                <div><?php echo e($category['name']); ?></div>
            </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script src="<?php echo e(asset('public/assets/front-end/js/categories.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/tupatane/public_html/resources/themes/default/web-views/products/categories.blade.php ENDPATH**/ ?>