<?php
    use App\Enums\ViewPaths\Admin\ErrorLogs;
    use App\Enums\ViewPaths\Admin\RobotsMetaContent;
    use App\Enums\ViewPaths\Admin\SEOSettings;
    use App\Enums\ViewPaths\Admin\SiteMap;
?>
<div class="inline-page-menu my-4">
    <ul class="list-unstyled">
        <li class="<?php echo e(Request::is('admin/seo-settings/'.SEOSettings::WEB_MASTER_TOOL[URI]) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.seo-settings.web-master-tool')); ?>">
                <?php echo e(translate('Webmaster_Tools')); ?>

            </a>
        </li>
        <li class="<?php echo e(Request::is('admin/seo-settings/'.SEOSettings::ROBOT_TXT[URI]) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.seo-settings.robot-txt')); ?>">
                <?php echo e(translate('Robots.txt')); ?>

            </a>
        </li>
        <li class="<?php echo e(Request::is('admin/seo-settings/'.SiteMap::SITEMAP[URI]) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.seo-settings.sitemap')); ?>">
                <?php echo e(translate('Sitemap')); ?>

            </a>
        </li>
        <li class="<?php echo e(Request::is('admin/seo-settings/robots-meta-content*') ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.seo-settings.robots-meta-content.index')); ?>">
                <?php echo e(translate('Robots_Meta_Content')); ?>

            </a>
        </li>
        <li class="<?php echo e(Request::is('admin/error-logs/'.ErrorLogs::INDEX[URI]) ? 'active' : ''); ?>">
            <a href="<?php echo e(route('admin.error-logs.index')); ?>">
                <?php echo e(translate('404_Logs')); ?>

            </a>
        </li>
    </ul>
</div>
<?php /**PATH /data/kariakooyetu/public_html/resources/views/admin-views/business-settings/seo-settings/_inline-menu.blade.php ENDPATH**/ ?>