<div class="card mt-3">
    <div class="px-3 py-4">
        <div class="d-flex flex-wrap justify-content-between gap-3 align-items-center">
            <div class="">
                <h5 class="text-capitalize d-flex gap-1 mb-0 ">
                    <?php echo e(translate('reason_list')); ?>

                    <span class="badge badge-soft-dark radius-50 fz-12"><?php echo e($vendorRegistrationReasons->total()); ?></span>
                </h5>
            </div>
            <button type="button" class="btn btn--primary btn-sm" data-toggle="modal" data-target="#reasonModal">
                <i class="tio-add"></i>
                <?php echo e(translate('add_Reason')); ?>

            </button>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table w-100 text-start">
            <thead class="thead-light thead-50 text-capitalize">
            <tr>
                <th><?php echo e(translate('SL')); ?></th>
                <th><?php echo e(translate('title')); ?></th>
                <th><?php echo e(translate('description')); ?></th>
                <th class="text-center"><?php echo e(translate('priority')); ?></th>
                <th class="text-center"><?php echo e(translate('status')); ?></th>
                <th class="text-center"><?php echo e(translate('action')); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $vendorRegistrationReasons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$reason): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($vendorRegistrationReasons->firstItem()+$key); ?></td>
                    <td>
                        <h5><?php echo e($reason['title']); ?></h5>
                    </td>
                    <td>
                        <div class="text-wrap max-w-500"><?php echo e($reason['description']); ?></div>
                    </td>
                    <td class="text-center"><?php echo e($reason['priority']); ?></td>
                    <td class="text-center">
                        <div class="d-flex justify-content-center">
                            <form action="<?php echo e(route('admin.business-settings.vendor-registration-reason.update-status')); ?>" method="post" id="update-reason-status<?php echo e($reason['id']); ?>-form">
                                <?php echo csrf_field(); ?>
                                <input name="id" value="<?php echo e($reason['id']); ?>" hidden>
                                <label class="switcher" for="update-reason-status<?php echo e($reason->id); ?>">
                                    <input type="checkbox" class="switcher_input toggle-switch-message" name="status"
                                           id="update-reason-status<?php echo e($reason['id']); ?>" value="1" <?php echo e($reason['status'] == 1 ? 'checked' : ''); ?>

                                           data-modal-id = "toggle-status-modal"
                                           data-toggle-id = "update-reason-status<?php echo e($reason->id); ?>"
                                           data-on-image = ""
                                           data-off-image = ""
                                           data-on-title = "<?php echo e(translate('want_to_Turn_ON_the_this_status').'?'); ?>"
                                           data-off-title = "<?php echo e(translate('want_to_Turn_OFF_the_this_status').'?'); ?>"
                                           data-on-message = ""
                                           data-off-message = "">
                                    <span class="switcher_control"></span>
                                </label>
                            </form>
                        </div>
                    </td>
                    <td>
                        <div class="d-flex justify-content-center gap-10">
                            <a class="btn btn-outline-info btn-sm square-btn vendor-registration-reason-update-view" title="<?php echo e(translate('edit')); ?>"
                               data-action="<?php echo e(route('admin.business-settings.vendor-registration-reason.update',['id'=>$reason['id']])); ?>">
                                <i class="tio-edit"></i>
                            </a>
                            <a href="javascript:" class="btn btn-outline-danger btn-sm square-btn delete-data-without-form"
                               data-action="<?php echo e(route('admin.business-settings.vendor-registration-reason.delete')); ?>"
                               data-id="<?php echo e($reason['id']); ?>" title="<?php echo e(translate('delete')); ?>">
                                <i class="tio-delete"></i>
                            </a>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <div class="table-responsive mt-4">
        <div class="px-4 d-flex justify-content-center justify-content-md-end">
            <?php echo e($vendorRegistrationReasons->links()); ?>

        </div>
    </div>
    <?php if(count($vendorRegistrationReasons)==0): ?>
        <?php echo $__env->make('layouts.back-end._empty-state',['text'=>'no_contact_found'],['image'=>'default'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
</div>
<?php echo $__env->make('admin-views.business-settings.vendor-registration-setting.partial.add-reason-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<div class="vendor-registration-reason-update-modal"></div>
<?php /**PATH /home/tupatane/public_html/resources/views/admin-views/business-settings/vendor-registration-setting/add-reason.blade.php ENDPATH**/ ?>