<div class="p-3 px-xl-4 py-sm-5">
    <div class="text-center">
        <img width="100" class="mb-4" id="view-mail-icon"
             src="<?php echo e($template->image_full_url['path'] ?? dynamicAsset(path: 'public/assets/back-end/img/email-template/congratulations.png')); ?>"
             alt="">
        <h3 class="mb-3 view-mail-title text-capitalize">
            <?php echo e($title); ?>

        </h3>
    </div>
    <div class="view-mail-body text-center">
        <?php echo $body; ?>

    </div>
    <div class="main-table-inner mb-4">
        <div class="d-flex justify-content-center pt-3">
            <img width="76" class="mb-4 mx-auto" id="view-mail-logo" src="<?php echo e($template->logo_full_url['path'] ?? getStorageImages(path: $companyLogo, type:'backend-logo')); ?>" alt="">
        </div>
        <div class="text-center">
            <h3 class="mb-3 "><?php echo e(translate('order_Info')); ?></h3>
            <p>
                <?php echo e(translate('to_verify_when_download_your_product').','.translate('_use_your_order_info').'.'); ?>

            </p>
        </div>

        <div class="main-table-inner bg-white" id="order-information">
            <div class="<?php echo e($template['order_information_status'] == 1 ? '' : 'd-none'); ?> table-responsive" >
                <table class="email-table">
                    <tr>
                        <td ><?php echo e(translate('Order').'#'.($data['order']->id ?? '312312')); ?></td>
                        <td ><?php echo e(($data['order']?->customer['phone'] ?? '+091231231')); ?></td>
                    </tr>
                    <tr>
                        <td>
                            <h4 class="mb-2"><?php echo e(translate('products')); ?></h4>
                            <?php if(isset($data['order'])): ?>
                                <?php $__currentLoopData = $data['order']->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php ($product = json_decode($detail['product_details'])); ?>
                                    <?php if($product->product_type == 'digital'): ?>
                                        <div class="d-flex align-items-center gap-3 mb-3">
                                            <img class="product-image"
                                                src="<?php echo e(getStorageImages(path: $detail?->productAllStatus?->thumbnail_full_url, type: 'backend-product')); ?>"
                                                 alt="">
                                            <div class="product-title"><?php echo e(substr($product->name, 0, 50)); ?></div>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <div class="d-flex align-items-center gap-3 min-w-200">
                                    <img class="product-image"
                                         src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/email-template/digital-product.png')); ?>"
                                         alt="">
                                    <div class="product-title"><?php echo e(translate('The Great Gatsby PDF')); ?></div>
                                </div>
                            <?php endif; ?>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="text-center gap-3 p-5">
            <div class="text-capitalize mb-2 mt-2"><?php echo e(translate('click_below')); ?></div>
            <a href="<?php echo e(isset($data['order']) ? route('digital-product-download-pos.index',['order_id'=>$data['order']->id,'email'=>$data['order']->customer['email']]) : 'javascript:'); ?>" class="<?php echo e(isset($data['order']) ? '' : 'cursor-default'); ?>"><?php echo e(url('digital-product-download-pos')); ?></a>
        </div>
    </div>
    <div>
        <p>
            <?php echo e(translate('don’t_share_your_order_information').', '.translate('_it’s_confidential').', '.translate('_if_you_share_this_info').', '.translate('_then_anyone_can_download').'.'); ?>

        </p>
        <p>
            <?php echo e(translate('meanwhile_click_here_to_visit_').$companyName.translate('_website')); ?>

            <br>
            <a href="<?php echo e(route('home')); ?>" target="_blank"><?php echo e(url('/')); ?></a>
        </p>
    </div>
    <hr>
    <?php echo $__env->make('admin-views.business-settings.email-template.partials-design.footer-design-without-logo-2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php /**PATH /home/tupatane/public_html/resources/views/admin-views/business-settings/email-template/customer-mail-template/digital-product-download.blade.php ENDPATH**/ ?>