<?php $__env->startSection('title', (request('filter') && request('filter') == 'top-vendors' ? translate('top_Stores') : translate('all_Stores'))); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta property="og:image" content="<?php echo e($web_config['web_logo']['path']); ?>"/>
    <meta property="og:title" content="Brands of <?php echo e($web_config['name']->value); ?> "/>
    <meta property="og:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="og:description" content="<?php echo e(substr(strip_tags(str_replace('&nbsp;', ' ', $web_config['about']->value)),0,160)); ?>">
    <meta property="twitter:card" content="<?php echo e($web_config['web_logo']['path']); ?>"/>
    <meta property="twitter:title" content="Brands of <?php echo e($web_config['name']->value); ?>"/>
    <meta property="twitter:url" content="<?php echo e(env('APP_URL')); ?>">
    <meta property="twitter:description" content="<?php echo e(substr(strip_tags(str_replace('&nbsp;', ' ', $web_config['about']->value)),0,160)); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div class="container mb-md-4 <?php echo e(Session::get('direction') === "rtl" ? 'rtl' : ''); ?> __inline-65">
        <div class="bg-primary-light rounded-10 my-4 p-3 p-sm-4" data-bg-img="<?php echo e(theme_asset(path: 'public/assets/front-end/img/media/bg.png')); ?>">
            <div class="row g-2 align-items-center">
                <div class="col-lg-8 col-md-6">
                    <div class="d-flex flex-column gap-1 text-primary">
                        <h4 class="mb-0 text-start fw-bold text-primary text-uppercase">
                            <?php echo e((request('filter') && request('filter') == 'top-vendors' ? translate('top_Stores') : translate('all_Stores'))); ?>

                        </h4>
                        <p class="fs-14 fw-semibold mb-0"><?php echo e(translate('Find_your_desired_stores_and_shop_your_favourite_products')); ?></p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6">
                    <form action="<?php echo e(route('vendors')); ?>" method="get">
                        <?php if(request('filter')): ?>
                            <input type="hidden" name="filter" value="<?php echo e(request('filter')); ?>">
                        <?php endif; ?>
                        <div class="input-group">
                            <input type="text" class="form-control rounded-10" value="<?php echo e(request('shop_name')); ?>"  placeholder="<?php echo e(translate('Search_Store')); ?>" name="shop_name">
                            <div class="input-group-append">
                                <button class="btn btn-outline-secondary rounded-10" type="submit"><?php echo e(translate('search')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="row">
            <section class="col-lg-12">
                <?php if(count($vendorsList) > 0): ?>
                    <div class="row mx-n2 __min-h-200px">
                        <?php $__currentLoopData = $vendorsList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vendorItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php ($current_date = date('Y-m-d')); ?>
                            <?php ($start_date = date('Y-m-d', strtotime($vendorItem['vacation_start_date']))); ?>
                            <?php ($end_date = date('Y-m-d', strtotime($vendorItem['vacation_end_date']))); ?>
                            <div class="col-lg-3 col-md-6 col-sm-12 px-2 pb-4 text-center">
                                <a href="<?php echo e(route('shopView',['id' => $vendorItem['id']])); ?>" class="others-store-card text-capitalize">
                                    <div class="overflow-hidden other-store-banner">
                                        <img class="w-100 h-100 object-cover" alt="" src="<?php echo e(getStorageImages(path: $vendorItem->banner_full_url, type: 'shop-banner')); ?>">
                                    </div>
                                    <div class="name-area">
                                        <div class="position-relative">
                                            <div class="overflow-hidden other-store-logo rounded-full">
                                                <img class="rounded-full" alt="<?php echo e(translate('store')); ?>"
                                                     src="<?php echo e(getStorageImages(path: $vendorItem->image_full_url, type: 'shop')); ?>">
                                            </div>

                                            <?php if($vendorItem['temporary_close']): ?>
                                                <span class="temporary-closed position-absolute text-center rounded-full p-2">
                                                    <span><?php echo e(translate('Temporary_OFF')); ?></span>
                                                </span>
                                            <?php elseif(($vendorItem['vacation_status'] && ($current_date >= $vendorItem['vacation_start_date']) && ($current_date <= $vendorItem['vacation_end_date']))): ?>
                                                <span class="temporary-closed position-absolute text-center rounded-full p-2">
                                                    <span><?php echo e(translate('closed_now')); ?></span>
                                                </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="info pt-2">
                                            <h5 class="text-start"><?php echo e($vendorItem['name']); ?></h5>
                                            <div class="d-flex align-items-center">
                                                <h6 class="web-text-primary"><?php echo e(number_format($vendorItem['average_rating'],1)); ?></h6>
                                                <i class="tio-star text-star mx-1"></i>
                                                <small><?php echo e(translate('rating')); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="info-area">
                                        <div class="info-item">
                                            <h6 class="web-text-primary"><?php echo e($vendorItem['review_count'] < 1000 ? $vendorItem['review_count'] : number_format($vendorItem['review_count']/1000 , 1).'K'); ?></h6>
                                            <span><?php echo e(translate('reviews')); ?></span>
                                        </div>
                                        <div class="info-item">
                                            <h6 class="web-text-primary"><?php echo e($vendorItem['products_count'] < 1000 ? $vendorItem['products_count'] : number_format($vendorItem['products_count']/1000 , 1).'K'); ?></h6>
                                            <span><?php echo e(translate('products')); ?></span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="row mx-n2">
                        <div class="col-md-12">
                            <div class="text-center">
                                <?php echo e($vendorsList->links()); ?>

                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="mb-5 text-center text-muted">
                        <div class="d-flex justify-content-center my-2">
                            <img alt="" src="<?php echo e(theme_asset(path: 'public/assets/front-end/img/media/seller.svg')); ?>">
                        </div>
                        <h4 class="text-muted"><?php echo e(translate('vendor_not_available')); ?></h4>
                        <p><?php echo e(translate('Sorry_no_data_found_related_to_your_search')); ?></p>
                    </div>
                <?php endif; ?>
            </section>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/kariakooyetu/public_html/resources/themes/default/web-views/seller-view/sellers.blade.php ENDPATH**/ ?>