<?php $__env->startSection('title', translate('SEO_Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex justify-content-between align-items-center gap-3 mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/seo-settings.svg')); ?>" alt="">
                <?php echo e(translate('SEO_Settings')); ?>

            </h2>
        </div>
        <?php echo $__env->make('admin-views.business-settings.seo-settings._inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card">
            <div class="card-header">
                <div class="w-100">
                    <h4 class="title m-0 text-capitalize"><?php echo e(translate('Webmaster_Tools')); ?></h4>
                    <p class="m-0">
                        <?php echo e(translate('optimize_websites_performance,_indexing_status,_and_search_visibility.')); ?>

                        <a href="<?php echo e('https://6amtech.com/blog/webmaster-tools-verification/'); ?>"
                           target="_blank"
                           class="text-underline text--primary font-weight-semibold">
                            <?php echo e(translate('Learn_more.')); ?>

                        </a>
                    </p>
                </div>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('admin.seo-settings.web-master-tool')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="p-4 border rounded mb-3">
                        <div class="row g-3">
                            <div class="col-md-4 col-xl-3">
                                <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/google-1.png')); ?>" alt="" width="30">
                                <h4 class="m-0 mt-3"><?php echo e(translate('google_search_console')); ?></h4>
                            </div>
                            <div class="col-md-8 col-xl-9">
                                <input type="text" name="google_search_console_code"  value="<?php echo e($webMasterToolData['google_search_console_code']); ?>" placeholder="<?php echo e(translate('enter_your_HTML_code_or_ID')); ?>" class="form-control">
                                <div class="mt-10px fs-12">
                                    <div><?php echo e(translate('Google_Console_verification_HTML_code_or_ID').'.'.translate('learn_how_to_get')); ?>

                                        <a href="<?php echo e('https://6amtech.com/blog/webmaster-tools-verification/'); ?>"
                                           target="_blank"
                                           class="text--primary text-underline font-weight-semibold text-capitalize">
                                            <?php echo e(translate('search_console_verification_page')); ?>

                                        </a>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <span class="badge badge-soft-danger p-2">
                                        &lt;meta name= “google-site-verification” content=”your-id” /&gt;
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="p-4 border rounded mb-20px">
                        <div class="row g-3">
                            <div class="col-md-4 col-xl-3">
                                <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/bing-1.png')); ?>" alt="" width="30">
                                <h4 class="m-0 mt-3 text-capitalize"><?php echo e(translate('bing_webmaster_tools')); ?></h4>
                            </div>
                            <div class="col-md-8 col-xl-9">
                                <input type="text" name="bing_webmaster_code" value="<?php echo e($webMasterToolData['bing_webmaster_code']); ?>" placeholder="<?php echo e(translate('enter_your_HTML_code_or_ID')); ?>" class="form-control">
                                <div class="mt-10px fs-12">
                                    <div>
                                        <?php echo e(translate('Bing_Webmaster_Tools_verification_HTML_code_or_ID').'.'.translate('learn_how_to_get')); ?>

                                        <a href="<?php echo e('https://6amtech.com/blog/webmaster-tools-verification/'); ?>"
                                           target="_blank"
                                           class="text--primary text-underline font-weight-semibold">
                                            <?php echo e(translate('search_console_verification_page')); ?>

                                        </a>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <span class="badge badge-soft-danger p-2">
                                        &lt;meta name= “msvalidate.01” content=”your-id” /&gt;
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="p-4 border rounded mb-3">
                        <div class="row g-3">
                            <div class="col-md-4 col-xl-3">
                                <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/baidu-1.png')); ?>" alt="" width="30">
                                <h4 class="m-0 mt-3 text-capitalize"><?php echo e(translate('baidu_webmaster_tool')); ?></h4>
                            </div>
                            <div class="col-md-8 col-xl-9">
                                <input type="text"  name="baidu_webmaster_code" value="<?php echo e($webMasterToolData['baidu_webmaster_code']); ?>" placeholder="<?php echo e(translate('enter_your_HTML_code_or_ID')); ?>" class="form-control">
                                <div class="mt-10px fs-12">
                                    <div>
                                        <?php echo e(translate('Baidu_Webmaster_Tools_verification_HTML_code_or_ID').'.'.translate('learn_how_to_get')); ?>

                                        <a href="<?php echo e('https://6amtech.com/blog/webmaster-tools-verification/'); ?>"
                                           target="_blank"
                                           class="text--primary text-underline font-weight-semibold">
                                            <?php echo e(translate('search_console_verification_page')); ?>

                                        </a>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <span class="badge badge-soft-danger p-2">
                                        &lt;meta name= “baidu-site-verification” content=”your-id” /&gt;
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="p-4 border rounded mb-20px">
                        <div class="row g-3">
                            <div class="col-md-4 col-xl-3">
                                <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/yandex-1.png')); ?>" alt="" width="30">
                                <h4 class="m-0 mt-3 text-capitalize"><?php echo e(translate('yandex_webmaster_tool')); ?></h4>
                            </div>
                            <div class="col-md-8 col-xl-9">
                                <input type="text"  name="yandex_webmaster_code" value="<?php echo e($webMasterToolData['yandex_webmaster_code']); ?>"  placeholder="<?php echo e(translate('enter_your_HTML_code_or_ID')); ?>" class="form-control">
                                <div class="mt-10px fs-12">
                                    <div>
                                        <?php echo e(translate('Yandex_Webmaster_Tools_verification_HTML_code_or_ID').'.'.translate('learn_how_to_get_it')); ?>

                                        <a href="<?php echo e('https://6amtech.com/blog/webmaster-tools-verification/'); ?>"
                                           target="_blank"
                                           class="text--primary text-underline font-weight-semibold">
                                            <?php echo e(translate('search_console_verification_page')); ?>

                                        </a>
                                    </div>
                                </div>
                                <div class="mt-3">
                                    <span class="badge badge-soft-danger p-2">
                                        &lt;meta name= “yandex-verification” content=”your-id” /&gt;
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="btn--container">
                        <button type="reset" class="btn btn-secondary"><?php echo e(translate('Reset')); ?></button>
                        <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>" class="btn btn--primary <?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>"><?php echo e(translate('Submit')); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/sdmkinga/tupatane.store/resources/views/admin-views/business-settings/seo-settings/web-master-tool.blade.php ENDPATH**/ ?>