<div class="p-3 px-xl-4 py-sm-5">
    <h3 class="mb-4 view-mail-title">
        <?php echo e($title); ?>

    </h3>
    <div class="view-mail-body">
        <?php echo $body; ?>

    </div>

    <div class="<?php echo e($template['button_content_status'] == 1 ? '' : 'd-none'); ?>" id="button-content">
        <div class="d-flex justify-content-center mb-4" >
            <a href="<?php echo e($template['button_url'] ?? route('track-order.index')); ?>" target="_blank"
               class="btn btn-primary view-button-content view-button-link m-auto"><?php echo e($buttonName ??translate('track_Order')); ?></a>
        </div>
    </div>
    <div class="main-table-inner mb-4">
        <div class="d-flex justify-content-center pt-3">
            <img class="mb-4 width-100px height-auto" id="view-mail-logo" src="<?php echo e($template->logo_full_url['path'] ?? getStorageImages(path: $companyLogo, type:'backend-logo')); ?>" alt="">
        </div>
        <h3 class="mb-3 text-center"><?php echo e(translate('order_Info')); ?></h3>
        <div class="main-table-inner bg-white">
            <div class="d-flex mb-3 p-2">
                <div class="flex-1 w-49">
                    <h3 class="mb-2"><?php echo e(translate('order_Summary')); ?></h3>
                    <div class="mb-2"><?php echo e(translate('Order').' # '.($data['order']->id ?? '432121')); ?> </div>
                    <div><?php echo e(date('d M, Y : h:i:A' ,strtotime($data['order']->created_at ?? now()))); ?></div>
                </div>
                <?php if(isset($data['send-mail'])): ?>
                    <?php
                        $showDeliveryAddress = false;
                            foreach ($data['order']->details as $key=>$detail){
                                $product = json_decode($detail->product_details);
                                if ($product->product_type == 'physical'){
                                    $showDeliveryAddress = true;
                                }
                            }
                    ?>
                   <?php if($showDeliveryAddress): ?>
                        <div class="flex-1 w-49">
                            <?php if($data['order']?->shippingAddress): ?>
                                <h3 class="mb-2"><?php echo e(translate('delivery_Address')); ?> </h3>
                                <div class="mb-2"><?php echo e($data['order']?->shippingAddress->contact_person_name); ?></div>
                                <div><?php echo e($data['order']?->shippingAddress?->address); ?></div>
                            <?php elseif($data['order']?->billingAddress): ?>
                                <h3 class="mb-2"><?php echo e(translate('delivery_Address')); ?> </h3>
                                <div class="mb-2"><?php echo e($data['order']?->billingAddress->contact_person_name); ?></div>
                                <div><?php echo e($data['order']?->billingAddress?->address); ?></div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php else: ?>
                    <div class="flex-1 w-49">
                    <h3 class="mb-2"><?php echo e(translate('delivery_Address')); ?> </h3>
                    <div class="mb-2"><?php echo e(translate('Munam Shahariar')); ?></div>
                    <div><?php echo e(translate('4517 Washington Ave. Manchester, Kentucky 39495')); ?></div>
                </div>
                <?php endif; ?>
            </div>
            <div class="<?php echo e($template['order_information_status'] == 1 ? '' : 'd-none'); ?>" id="order-information">
                <table class="email-table">
                    <thead>
                        <tr>
                            <th class="text-left"><?php echo e(translate('product')); ?></th>
                            <th class="text-right"><?php echo e(translate('price')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                  <?php if(isset($data['order'])): ?>
                    <?php
                      $itemPrice=0;
                      $totalPrice=0;
                      $subtotal=0;
                      $total=0;
                      $shipping=0;
                      $discount=0;
                      $tax=0;
                      $row=0;
                      $finalAmount = 0;
                    ?>
                    <?php $__currentLoopData = $data['order']->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php ($productDetails = $detail?->productAllStatus ?? json_decode($detail->product_details) ); ?>
                        <tr>
                            <td>
                                <div class="d-flex gap-2">
                                    <span class="text-nowrap"><?php echo e(++$row.'.'); ?> </span>
                                    <span><?php echo e($productDetails->name.' x '.$detail['qty']); ?></span>
                                </div>
                            </td>
                            <td class="text-right fw-bold"><?php echo e(webCurrencyConverter(amount: ($detail['price']*$detail['qty']))); ?></td>
                        </tr>
                        <?php ($itemPrice+=$detail['price']*$detail['qty']); ?>
                        <?php ($subtotal=$detail['price']*$detail['qty']-$detail['discount']); ?>
                        <?php ($discount+=$detail['discount']); ?>
                        <?php ($tax+=$detail['tax']); ?>
                        <?php ($total+=$subtotal); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php ($shipping=$data['order']['shipping_cost']); ?>
                    <?php ($couponDiscount = $data['order']['discount_amount']); ?>
                    <?php ($deliveryFeeDiscount = 0); ?>
                    <?php if($data['order']['is_shipping_free']): ?>
                        <?php ($deliveryFeeDiscount = $shipping); ?>
                    <?php endif; ?>
                      <?php ($finalAmount = $total+$tax+$shipping-$couponDiscount-$deliveryFeeDiscount); ?>

                  <?php else: ?>
                      <tr>
                          <td>
                              <div class="d-flex gap-2">
                                  <span><?php echo e(translate('1').'.'); ?> </span>
                                  <span><?php echo e(translate('The school of life - emotional baggage tote bag - canvas tote bag (navy) x 1')); ?></span>
                              </div>
                          </td>
                          <td class="text-right fw-bold"><?php echo e(setCurrencySymbol(amount: usdToDefaultCurrency(amount: 500), currencyCode: getCurrencyCode())); ?></td>
                      </tr>
                  <?php endif; ?>
                    </tbody>
                </table>
                <hr>
                <dl class="email-dl">
                    <dt class="flex-1"><?php echo e(translate('item_price')); ?></dt>
                    <dd class="flex-1 text-right">
                        <?php echo e(isset($itemPrice) ? webCurrencyConverter(amount: $itemPrice) :setCurrencySymbol(amount: usdToDefaultCurrency(amount: 500), currencyCode: getCurrencyCode())); ?>

                    </dd>
                    <dt class="flex-1"><?php echo e(translate('item_discount')); ?></dt>
                    <dd class="flex-1 text-right">
                        - <?php echo e(isset($discount) ? webCurrencyConverter(amount: $discount) :setCurrencySymbol(amount: usdToDefaultCurrency(amount: 50), currencyCode: getCurrencyCode())); ?>

                    </dd>
                    <dt class="flex-1"><?php echo e(translate('sub_total')); ?></dt>
                    <dd class="flex-1 text-right">
                        <?php echo e(isset($total) ? webCurrencyConverter(amount: $total) :setCurrencySymbol(amount: usdToDefaultCurrency(amount: 450), currencyCode: getCurrencyCode())); ?>

                    </dd>
                    <dt class="flex-1">
                        <?php echo e(translate('coupon_discount')); ?>

                    </dt>
                    <dd class="flex-1 text-right">
                        - <?php echo e(isset($couponDiscount) ? webCurrencyConverter(amount: $couponDiscount) :setCurrencySymbol(amount: usdToDefaultCurrency(amount: 0), currencyCode: getCurrencyCode())); ?>

                    </dd>                    <dt class="flex-1"><?php echo e(translate('vat/Tax')); ?></dt>
                    <dd class="flex-1 text-right">
                        <?php echo e(isset($tax) ? webCurrencyConverter(amount: $tax) :setCurrencySymbol(amount: usdToDefaultCurrency(amount: 25), currencyCode: getCurrencyCode())); ?>

                    </dd>
                    <dt class="flex-1">
                        <?php echo e(translate('delivery_fee')); ?>

                    </dt>
                    <dd class="flex-1 text-right">
                        <?php echo e(isset($shipping) ? webCurrencyConverter(amount: $shipping-$deliveryFeeDiscount) :setCurrencySymbol(amount: usdToDefaultCurrency(amount: 0), currencyCode: getCurrencyCode())); ?>

                    </dd>
                    <dt class="flex-1 fw-bold"><?php echo e(translate('Total')); ?></dt>
                    <dd class="flex-1 text-right text-success fw-bold fs">
                        <?php echo e(isset($finalAmount) ? webCurrencyConverter(amount: $finalAmount) :setCurrencySymbol(amount: usdToDefaultCurrency(amount: 475), currencyCode: getCurrencyCode())); ?>

                    </dd>
                </dl>
            </div>
            <hr>
            <p class="view-footer-text">
                <?php echo e($footerText); ?>

            </p>
            <p><?php echo e(translate('Thanks_&_Regards')); ?>, <br> <?php echo e(getWebConfig('company_name')); ?></p>
        </div>
    </div>
    <?php echo $__env->make('admin-views.business-settings.email-template.partials-design.footer-design-without-logo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php /**PATH /home/tupatane/public_html/resources/views/admin-views/business-settings/email-template/customer-mail-template/order-place.blade.php ENDPATH**/ ?>