<aside
    class="col-lg-3 hidden-xs col-md-3 col-sm-4 SearchParameters __search-sidebar <?php echo e(Session::get('direction') === "rtl" ? 'pl-2' : 'pr-2'); ?>"
    id="SearchParameters">
    <div class="cz-sidebar __inline-35 p-4 overflow-hidden" id="shop-sidebar">
        <div class="cz-sidebar-header p-0">
            <h6 class="font-semibold fs-20 mb-2"><?php echo e(translate('Sidebar')); ?></h6>
            <button class="close ms-auto fs-18-mobile"
                    type="button" data-dismiss="sidebar" aria-label="Close">
                <i class="tio-clear"></i>
            </button>
        </div>
        <div class="pb-0 shop-sidebar-scroll">
            <div class="d-flex gap-3 flex-column">

                <?php if($web_config['digital_product_setting']): ?>
                    <div class="">
                        <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('Product_Type')); ?></h6>
                        <label class="w-100 opacity-75 text-nowrap for-sorting d-block mb-0 ps-0" for="sorting">
                            <select class="form-control filter-on-product-type-change">
                                <option value="all" <?php echo e(!request('product_type') ? 'selected' : ''); ?>><?php echo e(translate('All')); ?></option>
                                <option value="physical" <?php echo e(request('product_type') == 'physical' ? 'selected' : ''); ?>>
                                    <?php echo e(translate('physical')); ?>

                                </option>
                                <option value="digital" <?php echo e(request('product_type') == 'digital' ? 'selected' : ''); ?>>
                                    <?php echo e(translate('digital')); ?>

                                </option>
                            </select>
                        </label>
                    </div>
                <?php endif; ?>

                <div class="d-lg-none">
                    <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('Sort_By')); ?></h6>
                    <form>
                        <select class="form-control product-list-filter-on-viewpage">
                            <option value="latest"><?php echo e(translate('latest')); ?></option>
                            <option value="low-high"><?php echo e(translate('low_to_High_Price')); ?> </option>
                            <option value="high-low"><?php echo e(translate('High_to_Low_Price')); ?></option>
                            <option value="a-z"><?php echo e(translate('A_to_Z_Order')); ?></option>
                            <option value="z-a"><?php echo e(translate('Z_to_A_Order')); ?></option>
                        </select>
                    </form>
                </div>

                <div>
                    <h6 class="font-semibold fs-15 mb-3"><?php echo e(translate('categories')); ?></h6>
                    <div class="accordion mt-n1 product-categories-list" id="shop-categories">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="menu--caret-accordion">
                                <div class="card-header flex-between">
                                    <div>
                                        <label class="for-hover-label cursor-pointer get-view-by-onclick"
                                               data-link="<?php echo e(route('shopView', ['id'=> $seller_id, 'category_id' => $category['id'], 'data_from' => 'category', 'page' => 1])); ?>">
                                            <?php echo e($category['name']); ?>

                                        </label>
                                    </div>
                                    <div class="px-2 cursor-pointer menu--caret">
                                        <strong class="pull-right for-brand-hover">
                                            <?php if($category->childes->count()>0): ?>
                                                <i class="tio-next-ui fs-13"></i>
                                            <?php endif; ?>
                                        </strong>
                                    </div>
                                </div>
                                <div
                                    class="card-body p-0 ms-2 d--none"
                                    id="collapse-<?php echo e($category['id']); ?>">
                                    <?php $__currentLoopData = $category->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="menu--caret-accordion">
                                            <div class="for-hover-label card-header flex-between">
                                                <div>
                                                    <label class="cursor-pointer get-view-by-onclick"
                                                           data-link="<?php echo e(route('shopView', ['id'=> $seller_id, 'category_id' => $child['id'], 'data_from' => 'category', 'page' => 1])); ?>">
                                                        <?php echo e($child['name']); ?>

                                                    </label>
                                                </div>
                                                <div class="px-2 cursor-pointer menu--caret">
                                                    <strong class="pull-right">
                                                        <?php if($child->childes->count()>0): ?>
                                                            <i class="tio-next-ui fs-13"></i>
                                                        <?php endif; ?>
                                                    </strong>
                                                </div>
                                            </div>
                                            <div
                                                class="card-body p-0 ms-2 d--none"
                                                id="collapse-<?php echo e($child['id']); ?>">
                                                <?php $__currentLoopData = $child->childes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="card-header">
                                                        <label
                                                            class="for-hover-label d-block cursor-pointer text-left get-view-by-onclick"
                                                            data-link="<?php echo e(route('shopView', ['id' => $seller_id, 'category_id' => $ch['id'], 'data_from' => 'category', 'page' => 1])); ?>">
                                                            <?php echo e($ch['name']); ?>

                                                        </label>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <?php if($web_config['brand_setting']): ?>
                    <div class="product-type-physical-section search-product-attribute-container">
                        <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('brands')); ?></h6>
                        <div class="pb-2">
                            <div class="input-group-overlay input-group-sm">
                                <input placeholder="<?php echo e(translate('search_by_brands')); ?>"
                                       class="__inline-38 cz-filter-search form-control form-control-sm appended-form-control search-product-attribute"
                                       type="text">
                                <div class="input-group-append-overlay">
                                        <span class="input-group-text">
                                            <i class="czi-search"></i>
                                        </span>
                                </div>
                            </div>
                        </div>
                        <div class="__brands-cate-wrap attribute-list" data-simplebar
                            data-simplebar-auto-hide="false">
                            <?php $__currentLoopData = $activeBrands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <ul
                                    class="brand mt-2 p-0 for-brand-hover <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : ''); ?>"
                                    id="brand">
                                    <li class="flex-between get-view-by-onclick cursor-pointer"
                                        data-link="<?php echo e(route('shopView', ['id'=> $seller_id, 'brand_id' => $brand['id'], 'data_from' => 'brand', 'page' => 1])); ?>"
                                    >
                                        <div class="text-start">
                                            <?php echo e($brand['name']); ?>

                                        </div>
                                        <div class="__brands-cate-badge">
                                            <span>
                                                <?php echo e($brand['brand_products_count']); ?>

                                            </span>
                                        </div>
                                    </li>
                                </ul>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($web_config['digital_product_setting'] && count($shopPublishingHouses) > 0): ?>
                    <div class="product-type-digital-section search-product-attribute-container">
                        <h6 class="font-semibold fs-15 mb-2"><?php echo e(translate('Publishing_House')); ?></h6>
                        <div class="pb-2">
                            <div class="input-group-overlay input-group-sm">
                                <input placeholder="<?php echo e(translate('search_by_name')); ?>"
                                       class="__inline-38 cz-filter-search form-control form-control-sm appended-form-control search-product-attribute"
                                       type="text">
                                <div class="input-group-append-overlay">
                                    <span class="input-group-text">
                                        <i class="czi-search"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="__brands-cate-wrap attribute-list" data-simplebar
                            data-simplebar-auto-hide="false">
                            <?php $__currentLoopData = $shopPublishingHouses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $publishingHouseItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <ul class="brand mt-2 p-0 for-brand-hover <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : ''); ?>"
                                     id="brand">
                                    <li class="flex-between get-view-by-onclick cursor-pointer"
                                        data-link="<?php echo e(route('shopView', ['id'=> $seller_id, 'publishing_house_id' => $publishingHouseItem['id'], 'product_type' => 'digital', 'page' => 1])); ?>"
                                    >
                                        <div class="text-start">
                                            <?php echo e($publishingHouseItem['name']); ?>

                                        </div>
                                        <div class="__brands-cate-badge">
                                            <span>
                                                <?php echo e($publishingHouseItem['publishing_house_products_count']); ?>

                                            </span>
                                        </div>
                                    </li>
                                </ul>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($web_config['digital_product_setting'] && count($digitalProductAuthors) > 0): ?>
                    <div class="product-type-digital-section search-product-attribute-container">
                        <h6 class="font-semibold fs-15 mb-2">
                            <?php echo e(translate('authors')); ?>/<?php echo e(translate('Creator')); ?>/<?php echo e(translate('Artist')); ?>

                        </h6>
                        <div class="pb-2">
                            <div class="input-group-overlay input-group-sm">
                                <input placeholder="<?php echo e(translate('search_by_name')); ?>"
                                       class="__inline-38 cz-filter-search form-control form-control-sm appended-form-control search-product-attribute"
                                       type="text">
                                <div class="input-group-append-overlay">
                                    <span class="input-group-text">
                                        <i class="czi-search"></i>
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="__brands-cate-wrap attribute-list" data-simplebar
                            data-simplebar-auto-hide="false">
                            <?php $__currentLoopData = $digitalProductAuthors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productAuthor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <ul class="brand mt-2 p-0 for-brand-hover <?php echo e(Session::get('direction') === "rtl" ? 'mr-2' : ''); ?>"
                                     id="brand">
                                    <li class="flex-between get-view-by-onclick cursor-pointer"
                                        data-link="<?php echo e(route('shopView', ['id'=> $seller_id, 'author_id' => $productAuthor['id'], 'product_type' => 'digital', 'page' => 1])); ?>">
                                        <div class="text-start">
                                            <?php echo e($productAuthor['name']); ?>

                                        </div>
                                        <div class="__brands-cate-badge">
                                            <span>
                                                <?php echo e($productAuthor['digital_product_author_count']); ?>

                                            </span>
                                        </div>
                                    </li>
                                </ul>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

            </div>
        </div>

    </div>
    <div class="sidebar-overlay"></div>
</aside>
<?php /**PATH /data/kariakooyetu/public_html/resources/themes/default/web-views/seller-view/partials/_shop-sidebar.blade.php ENDPATH**/ ?>