<?php $__env->startSection('title', translate('SEO_Settings')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex justify-content-between align-items-center gap-3 mb-3">
            <h2 class="h1 mb-0 text-capitalize d-flex align-items-center gap-2">
                <img src="<?php echo e(dynamicAsset(path: 'public/assets/back-end/img/seo-settings.svg')); ?>" alt="">
                <?php echo e(translate('SEO_Settings')); ?>

            </h2>
        </div>
        <?php echo $__env->make('admin-views.business-settings.seo-settings._inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="card shadow-none">
            <div class="card-header flex-wrap">
                <div class="">
                    <h4 class="title m-0"><?php echo e(translate('Robots.txt_Editor')); ?></h4>
                    <p class="m-0"><?php echo e(translate('control_search_engine_crawlers_access_to_specific_pages_on_a_website').'.'); ?></p>
                </div>

                <?php if(file_exists(base_path('robots.txt'))): ?>
                    <a class="btn btn-outline--primary" href="<?php echo e(url('/robots.txt')); ?>" target="_blank">
                        <span class="font-weight-semibold text-dark txt"><?php echo e(translate('view_URL')); ?></span>
                        <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/arrow-right.png')); ?>" alt="">
                    </a>
                <?php else: ?>
                    <button class="btn btn-outline--primary disabled" data-toggle="tooltip" title="<?php echo e(translate('Empty_File')); ?>">
                        <span class="font-weight-semibold text-dark txt"><?php echo e(translate('view_URL')); ?></span>
                        <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/arrow-right.png')); ?>" alt="">
                    </button>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <div class="mb-20px">
                    <div class="d-flex align-items-center gap-2 fs-12 p-3 rounded badge--info">
                        <img src="<?php echo e(dynamicAsset('public/assets/back-end/img/idea.png')); ?>" alt="">
                        <?php if(env('APP_MODE') == 'demo'): ?>
                            <div class="w-0 flex-grow">
                                <?php echo e(translate('the_robots.txt_editor_lets_you_tell_search_engines_which_parts_of_your_website_they_should_or_should_not_crawl.')); ?> <?php echo e(translate('please_note')); ?>:<?php echo e(translate('this_feature_is_disabled_for_demo.')); ?>

                            </div>
                        <?php else: ?>
                            <div class="w-0 flex-grow">
                                <?php echo e(translate('the_robots.txt_editor_lets_you_tell_search_engines_which_parts_of_your_website_they_should_or_should_not_crawl.')); ?> <?php echo e(translate('please_note')); ?>:<?php echo e(translate('the_system_will_automatically_generate_a_robot.txt_for_your_site.')); ?> <?php echo e(translate('you_do_not_have_to_create_it_manually.')); ?> <?php echo e(translate('but_you_can_edit_or_modify_this_robots.txt.')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>

                <form action="<?php echo e(route('admin.seo-settings.robot-txt')); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="mb-20px">
                        <textarea class="form-control" name="robot_text" rows="5"><?php echo e($content); ?></textarea>
                    </div>
                    <div class="btn--container">
                        <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                        <button type="<?php echo e(env('APP_MODE') == 'demo' ? 'button' : 'submit'); ?>" class="btn btn--primary <?php echo e(env('APP_MODE')!='demo'? '' : 'call-demo'); ?>">
                            <?php echo e(translate('submit')); ?>

                        </button>
                    </div>
                </form>
            </div>
        </div>

    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.back-end.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /data/sdmkinga/tupatane.store/resources/views/admin-views/business-settings/seo-settings/robot-txt.blade.php ENDPATH**/ ?>